/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.block;

import com.raoulvdberge.refinedpipes.item.AttachmentItem;
import com.raoulvdberge.refinedpipes.network.NetworkManager;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.Attachment;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.AttachmentManager;
import com.raoulvdberge.refinedpipes.network.pipe.shape.PipeShapeCache;
import com.raoulvdberge.refinedpipes.network.pipe.shape.PipeShapeProps;
import com.raoulvdberge.refinedpipes.tile.PipeTileEntity;
import com.raoulvdberge.refinedpipes.util.Raytracer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class PipeBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty INV_NORTH = BooleanProperty.func_177716_a((String)"inv_north");
    public static final BooleanProperty INV_EAST = BooleanProperty.func_177716_a((String)"inv_east");
    public static final BooleanProperty INV_SOUTH = BooleanProperty.func_177716_a((String)"inv_south");
    public static final BooleanProperty INV_WEST = BooleanProperty.func_177716_a((String)"inv_west");
    public static final BooleanProperty INV_UP = BooleanProperty.func_177716_a((String)"inv_up");
    public static final BooleanProperty INV_DOWN = BooleanProperty.func_177716_a((String)"inv_down");
    private final PipeShapeCache shapeCache;

    public PipeBlock(PipeShapeCache shapeCache) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.35f));
        this.shapeCache = shapeCache;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INV_NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INV_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INV_SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INV_WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INV_UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INV_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, INV_NORTH, INV_EAST, INV_SOUTH, INV_WEST, INV_UP, INV_DOWN});
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Pipe pipe;
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        if (!world.field_72995_K && (pipe = NetworkManager.get(world).getPipe(pos)) != null && pipe.getNetwork() != null) {
            pipe.getNetwork().scanGraph(world, pos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Direction dirClicked = this.getAttachmentDirectionClicked(pos, hit.func_216347_e());
        if (dirClicked != null) {
            ItemStack held = player.func_184614_ca();
            TileEntity tile = world.func_175625_s(pos);
            if (held.func_190926_b() && player.func_213453_ef()) {
                return this.removeAttachment(world, pos, dirClicked);
            }
            if (tile instanceof PipeTileEntity && ((PipeTileEntity)tile).getAttachmentManager().hasAttachment(dirClicked)) {
                return this.openAttachmentContainer(player, pos, ((PipeTileEntity)tile).getAttachmentManager(), dirClicked);
            }
            if (held.func_77973_b() instanceof AttachmentItem) {
                return this.addAttachment(player, world, pos, held, dirClicked);
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    private ActionResultType addAttachment(PlayerEntity player, World world, BlockPos pos, ItemStack attachment, Direction dir) {
        Pipe pipe;
        if (!world.field_72995_K && (pipe = NetworkManager.get(world).getPipe(pos)) != null && !pipe.getAttachmentManager().hasAttachment(dir)) {
            AttachmentFactory type = ((AttachmentItem)attachment.func_77973_b()).getFactory();
            if (!type.canPlaceOnPipe(this)) {
                return ActionResultType.SUCCESS;
            }
            pipe.getAttachmentManager().setAttachmentAndScanGraph(dir, type.create(pipe, dir));
            NetworkManager.get(world).func_76185_a();
            pipe.sendBlockUpdate();
            world.func_175656_a(pos, this.getState(world.func_180495_p(pos), (IWorld)world, pos));
            if (!player.func_184812_l_()) {
                attachment.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType removeAttachment(World world, BlockPos pos, Direction dir) {
        if (!world.field_72995_K) {
            Pipe pipe = NetworkManager.get(world).getPipe(pos);
            if (pipe != null && pipe.getAttachmentManager().hasAttachment(dir)) {
                Attachment attachment = pipe.getAttachmentManager().getAttachment(dir);
                pipe.getAttachmentManager().removeAttachmentAndScanGraph(dir);
                NetworkManager.get(world).func_76185_a();
                pipe.sendBlockUpdate();
                world.func_175656_a(pos, this.getState(world.func_180495_p(pos), (IWorld)world, pos));
                Block.func_180635_a((World)world, (BlockPos)pos.func_177972_a(dir), (ItemStack)attachment.getDrop());
            }
            return ActionResultType.SUCCESS;
        }
        return ((PipeTileEntity)world.func_175625_s(pos)).getAttachmentManager().hasAttachment(dir) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    private ActionResultType openAttachmentContainer(PlayerEntity player, BlockPos pos, AttachmentManager attachmentManager, Direction dir) {
        if (player instanceof ServerPlayerEntity) {
            attachmentManager.openAttachmentContainer(dir, (ServerPlayerEntity)player);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getState(this.func_176223_P(), (IWorld)ctx.func_195991_k(), ctx.func_195995_a());
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.shapeCache.getShape(state, world, pos, ctx);
    }

    private BlockState getState(BlockState currentState, IWorld world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.NORTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.EAST)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.WEST)))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.UP)))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.DOWN)))).func_206870_a((IProperty)INV_NORTH, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.NORTH)))).func_206870_a((IProperty)INV_EAST, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.EAST)))).func_206870_a((IProperty)INV_SOUTH, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.SOUTH)))).func_206870_a((IProperty)INV_WEST, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.WEST)))).func_206870_a((IProperty)INV_UP, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.UP)))).func_206870_a((IProperty)INV_DOWN, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.DOWN)));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tile;
        Direction dirClicked = this.getAttachmentDirectionClicked(pos, target.func_216347_e());
        if (dirClicked != null && (tile = world.func_175625_s(pos)) instanceof PipeTileEntity) {
            return ((PipeTileEntity)tile).getAttachmentManager().getPickBlock(dirClicked);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Nullable
    public Direction getAttachmentDirectionClicked(BlockPos pos, Vec3d hit) {
        if (Raytracer.inclusiveContains(PipeShapeProps.NORTH_ATTACHMENT_SHAPE.func_197752_a().func_186670_a(pos), hit)) {
            return Direction.NORTH;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.EAST_ATTACHMENT_SHAPE.func_197752_a().func_186670_a(pos), hit)) {
            return Direction.EAST;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.SOUTH_ATTACHMENT_SHAPE.func_197752_a().func_186670_a(pos), hit)) {
            return Direction.SOUTH;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.WEST_ATTACHMENT_SHAPE.func_197752_a().func_186670_a(pos), hit)) {
            return Direction.WEST;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.UP_ATTACHMENT_SHAPE.func_197752_a().func_186670_a(pos), hit)) {
            return Direction.UP;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.DOWN_ATTACHMENT_SHAPE.func_197752_a().func_186670_a(pos), hit)) {
            return Direction.DOWN;
        }
        return null;
    }

    protected abstract boolean hasConnection(IWorld var1, BlockPos var2, Direction var3);

    protected abstract boolean hasInvConnection(IWorld var1, BlockPos var2, Direction var3);
}

