/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.block;

import com.raoulvdberge.refinedpipes.block.PipeBlock;
import com.raoulvdberge.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.raoulvdberge.refinedpipes.network.pipe.shape.PipeShapeCache;
import com.raoulvdberge.refinedpipes.tile.FluidPipeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidPipeBlock
extends PipeBlock {
    private final FluidPipeType type;

    public FluidPipeBlock(PipeShapeCache shapeCache, FluidPipeType type) {
        super(shapeCache);
        this.type = type;
        this.setRegistryName(type.getId());
    }

    public FluidPipeType getType() {
        return this.type;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FluidPipeTileEntity(this.type);
    }

    @Override
    protected boolean hasConnection(IWorld world, BlockPos pos, Direction direction) {
        TileEntity currentTile = world.func_175625_s(pos);
        if (currentTile instanceof FluidPipeTileEntity && ((FluidPipeTileEntity)currentTile).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = world.func_180495_p(pos.func_177972_a(direction));
        TileEntity facingTile = world.func_175625_s(pos.func_177972_a(direction));
        if (facingTile instanceof FluidPipeTileEntity && ((FluidPipeTileEntity)facingTile).getAttachmentManager().hasAttachment(direction.func_176734_d())) {
            return false;
        }
        return facingState.func_177230_c() instanceof FluidPipeBlock && ((FluidPipeBlock)facingState.func_177230_c()).getType() == this.type;
    }

    @Override
    protected boolean hasInvConnection(IWorld world, BlockPos pos, Direction direction) {
        TileEntity facingTile = world.func_175625_s(pos.func_177972_a(direction));
        return facingTile != null && facingTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent();
    }
}

