/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge.config;

import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.ConfigManager;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge.ForgeUtils;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge.config.RegistryEntryAdapter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.maven.artifact.versioning.VersionRange;

public final class ForgeConfig {
    private ForgeConfig() {
    }

    public static void initialize() {
        ConfigManager.setClient(ForgeUtils.IS_CLIENT);
        ConfigManager.registerVersionChecker(ForgeConfig::testVersionRange);
        RegistryEntryAdapter.initialize();
    }

    private static boolean testVersionRange(Field field) {
        MinForgeBuild minForgeBuild;
        MCVersion mcVersion = field.getAnnotation(MCVersion.class);
        if (mcVersion != null) {
            String versionRange = mcVersion.value().trim();
            if (versionRange.isEmpty()) {
                throw new IllegalArgumentException("Version range must not be empty");
            }
            VersionRange range = MavenVersionAdapter.createFromVersionSpec((String)versionRange);
            if (!range.containsVersion(ForgeUtils.MC_ARTIFACT_VERSION)) {
                return false;
            }
        }
        if ((minForgeBuild = field.getAnnotation(MinForgeBuild.class)) == null) {
            return true;
        }
        int forgeBuild = minForgeBuild.value();
        if (forgeBuild < 1) {
            throw new IllegalArgumentException("Invalid Forge build: " + forgeBuild);
        }
        return ForgeUtils.FORGE_BUILD >= forgeBuild;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface MinForgeBuild {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface MCVersion {
        public String value();
    }
}

