/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge;

import com.google.common.base.Preconditions;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ForgeUtils {
    public static final boolean IS_DEOBFUSCATED;
    public static final boolean IS_CLIENT;
    public static final String MC_VERSION;
    public static final int MC_VERSION_NUMBER;
    public static final ArtifactVersion MC_ARTIFACT_VERSION;
    public static final int FORGE_BUILD;

    private ForgeUtils() {
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Boolean[]) {
            return ArrayUtils.toPrimitive((Boolean[])((Boolean[])array));
        }
        if (array instanceof Byte[]) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])array));
        }
        if (array instanceof Character[]) {
            return ArrayUtils.toPrimitive((Character[])((Character[])array));
        }
        if (array instanceof Double[]) {
            return ArrayUtils.toPrimitive((Double[])((Double[])array));
        }
        if (array instanceof Float[]) {
            return ArrayUtils.toPrimitive((Float[])((Float[])array));
        }
        if (array instanceof Integer[]) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])array));
        }
        if (array instanceof Long[]) {
            return ArrayUtils.toPrimitive((Long[])((Long[])array));
        }
        if (array instanceof Short[]) {
            return ArrayUtils.toPrimitive((Short[])((Short[])array));
        }
        throw new IllegalArgumentException("array should be a boxed array");
    }

    public static Object[] toBoxedArray(Object array) {
        Preconditions.checkNotNull((Object)array, (Object)"array should not be null");
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof boolean[]) {
            return ArrayUtils.toObject((boolean[])((boolean[])array));
        }
        if (array instanceof byte[]) {
            return ArrayUtils.toObject((byte[])((byte[])array));
        }
        if (array instanceof char[]) {
            return ArrayUtils.toObject((char[])((char[])array));
        }
        if (array instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])array));
        }
        if (array instanceof float[]) {
            return ArrayUtils.toObject((float[])((float[])array));
        }
        if (array instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])array));
        }
        if (array instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])array));
        }
        if (array instanceof short[]) {
            return ArrayUtils.toObject((short[])((short[])array));
        }
        throw new IllegalArgumentException("array should be an array");
    }

    public static Path getPath(String path) {
        return Paths.get(path, new String[0]).normalize();
    }

    public static String withUnixDirectorySeparators(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        return ForgeUtils.withUnixDirectorySeparators(path.toString());
    }

    public static String withUnixDirectorySeparators(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        return path.replace('\\', '/');
    }

    public static @Nullable Field findFieldNullable(Class<?> clazz, String ... names) {
        Preconditions.checkNotNull(clazz, (Object)"clazz should not be null");
        Preconditions.checkNotNull((Object)names, (Object)"names should not be null");
        for (Field field : clazz.getDeclaredFields()) {
            for (String name : names) {
                if (!name.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String ... names) {
        Field field = ForgeUtils.findFieldNullable(clazz, names);
        if (field == null) {
            throw new IllegalArgumentException("No such field " + Arrays.toString(names) + " in: " + clazz.getName());
        }
        return field;
    }

    public static @Nullable Method findMethodNullable(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ForgeUtils.findMethodNullable(clazz, name, name, parameterTypes);
    }

    public static @Nullable Method findMethodNullable(Class<?> clazz, String name, String obfuscatedName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz, (Object)"clazz should not be null");
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        Preconditions.checkNotNull((Object)obfuscatedName, (Object)"obfuscatedName should not be null");
        Preconditions.checkNotNull(parameterTypes, (Object)"parameterTypes should not be null");
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!name.equals(methodName) && !obfuscatedName.equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static @Nullable Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method method = ForgeUtils.findMethodNullable(clazz, name, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("No such method " + name + " in: " + clazz.getName());
        }
        return method;
    }

    public static @Nullable Method findMethod(Class<?> clazz, String name, String obfuscatedName, Class<?> ... parameterTypes) {
        Method method = ForgeUtils.findMethodNullable(clazz, name, obfuscatedName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("No such method " + name + " in: " + clazz.getName());
        }
        return method;
    }

    public static @Nullable Class<?> getClass(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ModLoadingStage getModLoadingStage() {
        return ((ModContainer)ModList.get().getModContainerById("forge").get()).getCurrentState();
    }

    public static boolean hasReachedStage(ModLoadingStage stage) {
        return stage.ordinal() <= ForgeUtils.getModLoadingStage().ordinal();
    }

    public static void crashReport(String message, Throwable throwable) {
        Preconditions.checkNotNull((Object)message, (Object)"message should not be null");
        Preconditions.checkNotNull((Object)throwable, (Object)"throwable should not be null");
        throw new ReportedException(new CrashReport(message, throwable));
    }

    static {
        IS_CLIENT = FMLEnvironment.dist.isClient();
        MC_VERSION = MCPVersion.getMCVersion();
        MC_VERSION_NUMBER = Integer.parseInt(MC_VERSION.split("\\.")[1]);
        MC_ARTIFACT_VERSION = new DefaultArtifactVersion(MC_VERSION);
        FORGE_BUILD = Integer.parseInt(ForgeVersion.getVersion().split("\\.")[2]);
        try {
            Object argumentHandler = ForgeUtils.findField(Launcher.class, "argumentHandler").get(Launcher.INSTANCE);
            Object launchTarget = ForgeUtils.findMethod(ArgumentHandler.class, "getLaunchTarget", new Class[0]).invoke(argumentHandler, new Object[0]);
            IS_DEOBFUSCATED = "fmluserdevclient".equals(launchTarget) || "fmluserdevserver".equals(launchTarget);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to determine launch target", ex);
        }
    }
}

