/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.recipe.json;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import com.valkyrieofnight.vlib.registry.recipe.AbstractRecipe;
import com.valkyrieofnight.vlib.registry.recipe.json.GsonTypesSerializer;
import com.valkyrieofnight.vlib.registry.recipe.json.JsonRecipeIO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class JsonRecipeDeserializer<RECIPE_TYPE extends AbstractRecipe>
implements ITypedDeserializer<JsonRecipe> {
    protected GsonTypesSerializer<? extends JsonRecipeIO> gson = new GsonTypesSerializer(this::addDeserializers);

    public JsonRecipeDeserializer() {
        this.gson.setup();
    }

    protected abstract void addDeserializers(GsonTypesSerializer<? extends JsonRecipeIO> var1);

    protected abstract RECIPE_TYPE createEmptyRecipe();

    public JsonRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jobj = json.getAsJsonObject();
        List<Object> inputs = Lists.newArrayList();
        List<Object> outputs = Lists.newArrayList();
        JsonElement inElement = jobj.get("inputs");
        JsonElement outElement = jobj.get("outputs");
        if (inElement != null && outElement != null) {
            JsonArray inArray = null;
            JsonArray outArray = null;
            if (inElement.isJsonArray()) {
                inArray = inElement.getAsJsonArray();
            }
            if (outElement.isJsonArray()) {
                outArray = outElement.getAsJsonArray();
            }
            if (inArray != null && outArray != null) {
                inputs = this.getEntries(inArray);
                outputs = this.getEntries(outArray);
            }
        }
        return null;
    }

    private List<JsonRecipeIO> getEntries(JsonArray array) {
        ArrayList arr = Lists.newArrayList();
        Map<String, ITypedDeserializer<? extends JsonRecipeIO>> deserializerMap = this.gson.getDeserializerMap();
        for (JsonElement je : array) {
            JsonObject jo;
            JsonObject jsonObject = jo = je.isJsonObject() ? je.getAsJsonObject() : null;
            if (jo == null) continue;
            for (String en : this.gson.getDeserializerTypeList()) {
                JsonElement jre = jo.get(en);
                if (jre == null) continue;
                ITypedDeserializer<? extends JsonRecipeIO> ds = deserializerMap.get(en);
                JsonRecipeIO jree = (JsonRecipeIO)this.gson.getGson().fromJson((JsonElement)jo, ds.getType());
                if (jree == null) continue;
                arr.add(jree);
            }
        }
        return arr;
    }

    @Override
    public TypeToken<JsonRecipe> getTypeToken() {
        return TypeToken.get(JsonRecipe.class);
    }

    @Override
    public String getTypeIdentifier() {
        return "recipe";
    }

    public static class JsonRecipe {
        public List<JsonRecipeIO> inputs = Lists.newArrayList();
        public List<JsonRecipeIO> outputs = Lists.newArrayList();
    }
}

