/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.tile.impl;

import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.TickTracker;
import com.valkyrieofnight.vlib.modifier.TileModifierHandler;
import com.valkyrieofnight.vlib.multiblock.component.impl.ComponentModifier;
import com.valkyrieofnight.vlib.multiblock.tile.impl.ControllerTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class ProcessorControllerTile
extends ControllerTile {
    private TickTracker tracker = TickTracker.Builder.create().setCanProcessStartProvider(this::internalCanProcessStart).setCanProcessTickProvider(this::internalCanProcessTick).setCanProcessCompleteProvider(this::internalCanProcessComplete).setOnProcessStartAction(this::onProcessStart).setOnProcessTickAction(this::onProcessTick).setOnProcessIdleTickAction(this::onProcessIdleTick).setOnProcessCompleteAction(this::onProcessComplete).setGetProcessDurationProvider(this::getProcessDuration).build();
    private TileModifierHandler modifierHandler;

    public ProcessorControllerTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.scanner.setOnConstructionComplete(this::internalOnConstructionComplete);
        this.modifierHandler = new TileModifierHandler(this);
    }

    protected abstract boolean canProcessStart();

    protected abstract boolean canProcessTick();

    protected abstract boolean canProcessComplete();

    protected abstract void onProcessStart();

    protected abstract void onProcessTick();

    protected abstract void onProcessIdleTick();

    protected abstract void onProcessComplete();

    protected abstract int getProcessDuration();

    private boolean internalCanProcessStart() {
        return this.scanner.isFormed() && this.canProcessStart();
    }

    private boolean internalCanProcessTick() {
        return this.scanner.isFormed() && this.canProcessTick();
    }

    private boolean internalCanProcessComplete() {
        return this.scanner.isFormed() && this.canProcessComplete();
    }

    private void internalOnConstructionComplete() {
        this.modifierHandler.queueModifiers(this.scanner.getAllOfType(ComponentModifier.getInstance()));
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        if (this.scanner.isFormed()) {
            this.tracker.tick();
            this.modifierHandler.tick();
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        super.save(nbt, type);
        if (type == SaveDataType.TILE || type == SaveDataType.CLIENT) {
            CompoundNBT trackerNBT = this.tracker.serializeNBT();
            nbt.func_218657_a("tracker", (INBT)trackerNBT);
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        super.load(nbt, type);
        if ((type == SaveDataType.TILE || type == SaveDataType.CLIENT) && nbt.func_74764_b("tracker")) {
            this.tracker.deserializeNBT(nbt.func_74775_l("tracker"));
        }
    }
}

