/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.base;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.debug.SimpleDebugger;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.ui.theme.server.ThemeRegistryServer;
import com.valkyrieofnight.vlib.core.util.modloader.SideUtil;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistry;
import com.valkyrieofnight.vlib.module.base.VLModule;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.core.VLMainModule;
import com.valkyrieofnight.vlib.module.interfaces.IInit;
import com.valkyrieofnight.vlib.module.interfaces.IInitClient;
import com.valkyrieofnight.vlib.module.interfaces.IInitServer;
import com.valkyrieofnight.vlib.module.proxy.ProxyClient;
import com.valkyrieofnight.vlib.module.proxy.ProxyCommon;
import com.valkyrieofnight.vlib.module.proxy.ProxyServer;
import java.util.concurrent.ConcurrentMap;

public abstract class VLMod {
    private static ConcurrentMap<String, EventTracker> tracked = Maps.newConcurrentMap();
    private final String modid;
    private SimpleDebugger debugger;
    private VLMainModule mainModule;
    private ProxyCommon proxy;
    private String configBaseDirectory;
    private VLRegistry registry;

    protected static boolean allModsComplete() {
        for (EventTracker e : tracked.values()) {
            if (e.isComplete()) continue;
            return false;
        }
        return true;
    }

    public VLMod(String modid) {
        this.modid = modid;
        this.debugger = new SimpleDebugger(modid, "config/" + modid + "/log.log");
        this.debugger.log("Mod ID: " + modid);
        this.debugger.setEnabled(false);
        this.mainModule = new VLMainModule(this, modid, this.debugger){

            @Override
            public void init(IConfig config) {
                VLMod.this._init(config);
            }

            @Override
            public void initServer(IConfig config) {
                VLMod.this._initServer(config);
            }

            @Override
            public void initClient(IConfig config) {
                VLMod.this._initClient(config);
            }

            @Override
            public void setupModule() {
                VLMod.this.setupMod();
            }

            @Override
            public boolean createUniqueThemeRegistry() {
                return VLMod.this.createThemeRegistry();
            }
        };
        this.configBaseDirectory = "config/";
        this.setup2();
    }

    public VLMod(String suite, String member) {
        this.modid = suite + member;
        this.setup1(suite, member);
        this.setup2();
    }

    public VLMod(String suite, String member, String modid) {
        this.modid = modid;
        this.setup1(suite, member);
        this.setup2();
    }

    private void setup1(String suite, String member) {
        this.debugger = new SimpleDebugger(this.modid, "config/" + suite + "/" + member + ".log");
        this.debugger.log("Suite ID: " + suite);
        this.debugger.log("Member ID: " + member);
        this.debugger.log("Mod ID: " + this.modid);
        this.mainModule = new VLMainModule(this, member, this.debugger){

            @Override
            public void init(IConfig config) {
                VLMod.this._init(config);
            }

            @Override
            public void initServer(IConfig config) {
                VLMod.this._initServer(config);
            }

            @Override
            public void initClient(IConfig config) {
                VLMod.this._initClient(config);
            }

            @Override
            public void setupModule() {
                VLMod.this.setupMod();
            }

            @Override
            public boolean createUniqueThemeRegistry() {
                return VLMod.this.createThemeRegistry();
            }
        };
        this.configBaseDirectory = "config/" + suite + "/";
    }

    private void setup2() {
        tracked.putIfAbsent(this.modid, new EventTracker());
        this.proxy = SideUtil.isClient() ? new ProxyClient(this, this.debugger, ThemeRegistryClient.getInstance()) : new ProxyServer(this, this.debugger, ThemeRegistryServer.getInstance());
        this.registry = this.proxy.getRegistry();
        this.mainModule._0moduleSetup();
        this.mainModule._1moduleConfigurationSetup(this.configBaseDirectory);
        this.proxy.registerAssets();
        this.debugger.log("Setup Complete");
        ((EventTracker)VLMod.tracked.get((Object)this.modid)).setup = true;
    }

    public abstract void setupMod();

    public final void initMod() {
        this.mainModule._3init();
        this.proxy.init();
        this.mainModule._5saveConfigs();
        ((EventTracker)VLMod.tracked.get((Object)this.modid)).init = true;
    }

    public void addChild(VLModule module) {
        if (module != null) {
            this.mainModule.addChild(module);
        }
    }

    private void _init(IConfig config) {
        if (this instanceof IInit) {
            ((IInit)((Object)this)).init(config);
        }
    }

    private void _initServer(IConfig config) {
        if (this instanceof IInitServer) {
            ((IInitServer)((Object)this)).initServer(config);
        }
    }

    private void _initClient(IConfig config) {
        if (this instanceof IInitClient) {
            ((IInitClient)((Object)this)).initClient(config);
        }
    }

    public final VLMainModule getMainModule() {
        return this.mainModule;
    }

    public boolean createThemeRegistry() {
        return false;
    }

    public ThemeRegistry getThemeRegistry() {
        return this.registry.getThemeRegistry();
    }

    public ProxyCommon getProxy() {
        return this.proxy;
    }

    private static class EventTracker {
        protected boolean setup = false;
        protected boolean init = false;

        private EventTracker() {
        }

        public boolean isComplete() {
            return this.setup && this.init;
        }
    }
}

