/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import java.util.Map;

public class Theme {
    protected ThemeID id;
    protected ThemeRegistryClient reg;
    protected Map<AssetID, GuiSizableBox> boxMap = Maps.newHashMap();
    protected Map<AssetID, Color4> colorMap = Maps.newHashMap();
    protected Map<AssetID, GuiTexture> textureMap = Maps.newHashMap();

    protected Theme(ThemeID id, ThemeRegistryClient reg) {
        this.id = id;
        this.reg = reg;
        ThemeRegistryClient.getInstance().addThemeAssetContainer(id, this::registerAssetsInternal);
    }

    protected void registerAssetsInternal(ThemeAssetContainer container) {
    }

    public GuiSizableBox getSizableBox(AssetID id) {
        GuiSizableBox r = this.boxMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getSizableBox(id);
    }

    public Color4 getColor(AssetID id) {
        Color4 r = this.colorMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getColor(id);
    }

    public GuiTexture getTexture(AssetID id) {
        GuiTexture r = this.textureMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getTexture(id);
    }

    public static class ThemeAssetContainer {
        protected ThemeRegistryClient themeRegistryClient;
        protected ThemeID id;
        protected Map<AssetID, GuiSizableBox> boxMap = Maps.newHashMap();
        protected Map<AssetID, Color4> colorMap = Maps.newHashMap();
        protected Map<AssetID, GuiTexture> textureMap = Maps.newHashMap();

        public static ThemeAssetContainer create(ThemeID id, ThemeRegistryClient registryClient) {
            return new ThemeAssetContainer(id, registryClient);
        }

        private ThemeAssetContainer(ThemeID id, ThemeRegistryClient registryClient) {
            this.id = id;
            this.themeRegistryClient = registryClient;
        }

        public ThemeID getThemeID() {
            return this.id;
        }

        public ThemeRegistryClient getThemeRegistry() {
            return this.themeRegistryClient;
        }

        public ThemeAssetContainer addBox(AssetID id, GuiSizableBox box) {
            if (id == null || box == null || this.boxMap.containsKey(id)) {
                System.err.println("Box failed to register with ID: " + id + " in Theme: " + this.id);
                return this;
            }
            this.boxMap.put(id, box);
            return this;
        }

        public ThemeAssetContainer addColor(AssetID id, Color4 color) {
            if (id == null || color == null || this.colorMap.containsKey(id)) {
                System.err.println("Color failed to register with ID: " + id + " in Theme: " + this.id);
                return this;
            }
            this.colorMap.put(id, color);
            return this;
        }

        public ThemeAssetContainer addTexture(AssetID id, GuiTexture texture) {
            if (id == null || texture == null || this.textureMap.containsKey(id)) {
                System.err.println("Texture failed to register with ID: " + id + " in Theme: " + this.id);
                return this;
            }
            this.textureMap.put(id, texture);
            return this;
        }
    }
}

