/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.client.gui.AbstractGui;

public abstract class GuiSizable {
    protected static final AbstractGui DRAWER = new AbstractGui(){};
    protected final VLID texture;
    protected GuiTexture[][] textures;
    protected int unitXSize;
    protected int unitYSize;
    protected int unitXSizeMiddle;
    protected int unitYSizeMiddle;
    protected boolean repeatMiddle;

    protected GuiSizable(VLID tex, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable) {
        this.texture = tex;
        this.repeatMiddle = middleRepeatable;
        this.textures = new GuiTexture[3][3];
        this.unitXSize = unitCornerX;
        this.unitYSize = unitCornerY;
        this.unitXSizeMiddle = unitMiddleX;
        this.unitYSizeMiddle = unitMiddleY;
    }

    protected void setGuiTexture(SizableLocation loc, GuiTexture tex) {
        this.textures[loc.y][loc.x] = tex;
    }

    public GuiTexture getGuiTexture(SizableLocation loc) {
        return this.textures[loc.y][loc.x];
    }

    public VLID getResourceLocation() {
        return this.texture;
    }

    public int getUnitCornerX() {
        return this.unitXSize;
    }

    public int getUnitCornerY() {
        return this.unitYSize;
    }

    public int getUnitMiddleX() {
        return this.unitXSizeMiddle;
    }

    public int getUnitMiddleY() {
        return this.unitYSizeMiddle;
    }

    public boolean getMiddleRepeatable() {
        return this.repeatMiddle;
    }

    public abstract void render(IElementContainer var1, int var2, int var3, int var4, int var5);

    public static enum SizableLocation {
        TOP_LEFT(0, 0),
        TOP_MID(0, 1),
        TOP_RIGHT(0, 2),
        MID_LEFT(1, 0),
        MID(1, 1),
        MID_RIGHT(1, 2),
        BOT_LEFT(2, 0),
        BOT_MID(2, 1),
        BOT_RIGHT(2, 2);

        public int x;
        public int y;

        private SizableLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

