/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import org.jetbrains.annotations.NotNull;

public abstract class BaseContainerElement
extends VLElement
implements IElementContainer,
IElementDraw,
IElementInput {
    public BaseContainerElement(String id) {
        super(id);
    }

    @Override
    public final void initContainer() {
        this.addElements();
        GuiUtils.initContainerAll(this.getElementList());
    }

    @Override
    public final Screen getGui() {
        return this.getContainer().getGui();
    }

    @Override
    public final Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public final void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(this.getElementList(), current);
    }

    @NotNull
    protected abstract List<IElement> getElementList();

    public abstract void addElements();

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseClickedCheckAll(this.getElementList(), mouseX, mouseY, mouseButton, this);
        return this.withinBounds((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseReleasedCheckAll(this.getElementList(), mouseX, mouseY, mouseButton, this);
        return this.withinBounds((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean emouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        GuiUtils.mouseDraggedCheckAll(this.getElementList(), mouseX, mouseY, mouseButton, mouseXScroll, mouseYScroll, this);
        return this.withinBounds((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        return GuiUtils.mouseScrolledCheckAll(this.getElementList(), mouseX, mouseY, scrolled, this);
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        return GuiUtils.keyPressedCheckAll(this.getElementList(), key, scanCode, modifiers, this);
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        return GuiUtils.keyReleasedCheckAll(this.getElementList(), key, scanCode, modifiers, this);
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        return GuiUtils.charTypedCheckAll(this.getElementList(), ch, modifiers, this);
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseReleasedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        this.getContainer().mouseDraggedResponse(element, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
        this.getContainer().mouseScrolledResponse(element, mouseX, mouseY, scrolled);
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyPressedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyReleasedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
        this.getContainer().charTypedResponse(element, ch, modifiers);
    }
}

