/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.block.base;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraftforge.common.ToolType;

public class BlockProps {
    private Block.Properties blockProperties;
    private Item.Properties itemProperties;

    public BlockProps(Material mat, DyeColor color) {
        this.blockProperties = Block.Properties.func_200952_a((Material)mat, (DyeColor)color);
        this.itemProperties = new Item.Properties();
    }

    public BlockProps(Material mat, MaterialColor matColor) {
        this.blockProperties = Block.Properties.func_200949_a((Material)mat, (MaterialColor)matColor);
        this.itemProperties = new Item.Properties();
    }

    public BlockProps(Material mat) {
        this.blockProperties = Block.Properties.func_200945_a((Material)mat);
        this.itemProperties = new Item.Properties();
    }

    public Block.Properties getProperties() {
        return this.blockProperties;
    }

    public Item.Properties getItemProperties() {
        return this.itemProperties;
    }

    public BlockProps maxStackSize(int size) {
        this.itemProperties.func_200917_a(size);
        return this;
    }

    public BlockProps defaultMaxDamage(int durability) {
        this.itemProperties.func_200915_b(durability);
        return this;
    }

    public BlockProps maxDamage(int durability) {
        this.itemProperties.func_200918_c(durability);
        return this;
    }

    public BlockProps containerItem(Item item) {
        this.itemProperties.func_200919_a(item);
        return this;
    }

    public BlockProps group(ItemGroup itemGroup) {
        this.itemProperties.func_200916_a(itemGroup);
        return this;
    }

    public BlockProps rarity(Rarity rarity) {
        this.itemProperties.func_208103_a(rarity);
        return this;
    }

    public BlockProps setISTER(Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
        this.itemProperties.setISTER(ister);
        return this;
    }

    public BlockProps doesNotBlockMovement() {
        this.blockProperties.func_200942_a();
        return this;
    }

    public BlockProps notSolid() {
        this.blockProperties.func_226896_b_();
        return this;
    }

    public BlockProps slipperiness(float amt) {
        this.blockProperties.func_200941_a(amt);
        return this;
    }

    public BlockProps speedFactor(float p_226898_1_) {
        this.blockProperties.func_226897_b_(p_226898_1_);
        return this;
    }

    public BlockProps jumpFactor(float p_226897_1_) {
        this.blockProperties.func_226898_c_(p_226897_1_);
        return this;
    }

    public BlockProps sound(SoundType soundTypeIn) {
        this.blockProperties.func_200947_a(soundTypeIn);
        return this;
    }

    public BlockProps lightValue(int lightValueIn) {
        this.blockProperties.func_200951_a(lightValueIn);
        return this;
    }

    public BlockProps hardnessAndResistance(float hardness, float resistance) {
        this.blockProperties.func_200948_a(hardness, resistance);
        return this;
    }

    protected BlockProps zeroHardnessAndResistance() {
        return this.hardnessAndResistance(0.0f);
    }

    public BlockProps hardnessAndResistance(float hardnessAndResistance) {
        this.hardnessAndResistance(hardnessAndResistance, hardnessAndResistance);
        return this;
    }

    public BlockProps tickRandomly() {
        this.blockProperties.func_200944_c();
        return this;
    }

    public BlockProps variableOpacity() {
        this.blockProperties.func_208770_d();
        return this;
    }

    public BlockProps harvestLevel(int harvestLevel) {
        this.blockProperties.harvestLevel(harvestLevel);
        return this;
    }

    public BlockProps harvestTool(ToolType harvestTool) {
        this.blockProperties.harvestTool(harvestTool);
        return this;
    }

    public BlockProps noDrops() {
        this.blockProperties.func_222380_e();
        return this;
    }

    public BlockProps lootFrom(Block blockIn) {
        this.blockProperties.func_222379_b(blockIn);
        return this;
    }
}

