/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PropParserBase<T extends PropBase> {
    public static final String SEPARATOR = ":";
    public static final char LINE_HOR = '\u2501';
    public static final char LINE_VER = '\u2503';
    public static final char LINE_TLC = '\u250f';
    public static final char LINE_TRC = '\u2513';
    public static final char LINE_BLC = '\u2517';
    public static final char LINE_BRC = '\u251b';
    public static final char LINE_VCR = '\u2523';
    public static final char LINE_VCL = '\u252b';
    public static final char LINE_HCD = '\u2533';
    public static final char LINE_HCU = '\u253b';
    public static final char LINE_HRH = '\u257a';
    public static final char LINE_HLH = '\u2578';
    public static final char LINE_VTH = '\u2579';
    public static final char LINE_VBH = '\u257b';
    protected final String prefix;
    public static final String COMMENT_PREFIX = "\u2523> ";
    public static final String COMMENT_PREFIX_LAST = "\u2517> ";
    public static final String MAP_KEY_PREFIX = "\u250f\u2578";

    public PropParserBase(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public abstract T fromJson(@NotNull JsonElement var1) throws Exception;

    public abstract JsonElement toJson(@NotNull T var1) throws Exception;

    public List<String> getLocalizedDocumentation(T prop) {
        ArrayList data = Lists.newArrayList();
        data.add(MAP_KEY_PREFIX + ((PropBase)prop).getMapKey());
        data.add(COMMENT_PREFIX + LangUtil.toLoc("valkyrielib.variabletype") + ": " + ((PropBase)prop).getVariableType().getTypeName());
        data.add(COMMENT_PREFIX + LangUtil.toLoc("valkyrielib.default") + ": " + ((PropBase)prop).getDefaultValue());
        String extra = ((PropBase)prop).getExtra();
        if (!StringUtils.isNullOrEmpty(extra)) {
            data.add(COMMENT_PREFIX + LangUtil.toLoc("valkyrielib.requirements") + ": " + extra);
        }
        List<String> unloc = ((PropBase)prop).getDocumentation();
        for (int i = 0; i < unloc.size(); ++i) {
            String str = unloc.get(i);
            if (i == unloc.size() - 1) {
                data.add(COMMENT_PREFIX_LAST + LangUtil.toLoc(str));
                continue;
            }
            data.add(COMMENT_PREFIX + LangUtil.toLoc(str));
        }
        if (unloc.size() == 0) {
            data.add("\u2517\u2578");
        }
        return data;
    }
}

