/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tmechworks.common.MechworksContent;
import slimeknights.tmechworks.common.config.MechworksConfig;

public class MechworksWorld {
    private static final List<OreProperties> OVERWORLD_ORES = ImmutableList.of((Object)new OreProperties(MechworksContent.Blocks.copper_ore.func_176223_P(), new CountRangeConfig(8, 40, 0, 75), 8, MechworksConfig.WORLD_GENERATION.COPPER), (Object)new OreProperties(MechworksContent.Blocks.aluminum_ore.func_176223_P(), new CountRangeConfig(8, 40, 0, 75), 8, MechworksConfig.WORLD_GENERATION.ALUMINUM));

    public static void registerWorldGeneration() {
        if (!((Boolean)MechworksConfig.WORLD_GENERATION.enabled.get()).booleanValue()) {
            return;
        }
        for (Biome biome : ForgeRegistries.BIOMES.getValues().stream().filter(x -> x.func_201856_r() != Biome.Category.THEEND && x.func_201856_r() != Biome.Category.NETHER).collect(Collectors.toList())) {
            MechworksWorld.addOresTo(biome);
        }
    }

    private static void addOresTo(Biome biome) {
        OVERWORLD_ORES.forEach(ore -> ((OreProperties)ore).add(biome));
    }

    private static class OreProperties {
        private final BlockState state;
        private final CountRangeConfig countRange;
        private final int frequency;
        private final MechworksConfig.WorldGeneration.Ore config;

        OreProperties(BlockState state, CountRangeConfig countRange, int frequency, MechworksConfig.WorldGeneration.Ore config) {
            this.state = state;
            this.countRange = countRange;
            this.frequency = frequency;
            this.config = config;
        }

        private void add(Biome biome) {
            if (!((Boolean)this.config.enabled.get()).booleanValue()) {
                return;
            }
            boolean isWhitelist = (Boolean)this.config.isWhitelist.get();
            List filter = (List)this.config.filter.get();
            boolean matches = filter.stream().anyMatch(val -> biome.getRegistryName().toString().equals(val));
            if (isWhitelist && !matches || !isWhitelist && matches) {
                return;
            }
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, this.state, this.frequency)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)this.countRange)));
        }
    }
}

