/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.inventory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tmechworks.common.MechworksContent;
import slimeknights.tmechworks.common.blocks.tileentity.DrawbridgeTileEntity;
import slimeknights.tmechworks.common.inventory.slots.ValidatingSlot;

public class DrawbridgeContainer
extends BaseContainer<DrawbridgeTileEntity> {
    public static final int ADVANCED_COLUMNS = 11;
    public final PlayerInventory playerInventory;
    public final int rows;
    public final ImmutableList<Slot> mainSlots;

    public DrawbridgeContainer(int id, PlayerInventory playerInventory, DrawbridgeTileEntity te) {
        super(MechworksContent.Containers.drawbridge, id, playerInventory, (TileEntity)te);
        this.playerInventory = playerInventory;
        te.func_174889_b(playerInventory.field_70458_d);
        this.rows = MathHelper.func_76123_f((float)((float)te.slots.func_70302_i_() / 11.0f));
        this.mainSlots = this.addDrawbridgeSlots();
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                this.func_75146_a(new ValidatingSlot(((DrawbridgeTileEntity)this.tile).upgrades, x * 2 + y, -36 + x * 18, 119 + y * 18));
            }
        }
        this.func_75146_a(new ValidatingSlot((IInventory)((DrawbridgeTileEntity)this.tile).getDisguiseInventory(), 0, 178, 137));
        this.addInventorySlots();
    }

    protected ImmutableList<Slot> addDrawbridgeSlots() {
        if (!((DrawbridgeTileEntity)this.tile).stats.isAdvanced) {
            return ImmutableList.of((Object)this.func_75146_a(new ValidatingSlot(((DrawbridgeTileEntity)this.tile).slots, 0, 80, 36)));
        }
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int slotCount = ((DrawbridgeTileEntity)this.tile).slots.func_70302_i_();
        int left = -11;
        int width = 198;
        int height = 126;
        int top = -5 - this.rows * 18 / 2;
        for (int y = 0; y < this.rows; ++y) {
            int cols = Math.min(slotCount - 11 * y, 11);
            int yCoord = top + y * 18;
            int xStart = 88 - cols * 18 / 2;
            for (int x = 0; x < cols; ++x) {
                int xCoord = xStart + x * 18;
                slots.add(this.func_75146_a(new ValidatingSlot(((DrawbridgeTileEntity)this.tile).slots, y * 11 + x, xCoord + 1, yCoord + 1)));
            }
        }
        return ImmutableList.copyOf(slots);
    }

    public static DrawbridgeContainer factory(int id, PlayerInventory playerInventory, PacketBuffer extraData) {
        BlockPos pos = extraData.func_179259_c();
        TileEntity te = playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        DrawbridgeTileEntity drawbridge = null;
        if (te instanceof DrawbridgeTileEntity) {
            drawbridge = (DrawbridgeTileEntity)te;
        }
        return new DrawbridgeContainer(id, playerInventory, drawbridge);
    }
}

