/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.blocks.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import slimeknights.mantle.tileentity.InventoryTileEntity;
import slimeknights.tmechworks.client.model.DisguiseBakedModel;
import slimeknights.tmechworks.common.blocks.RedstoneMachineBlock;
import slimeknights.tmechworks.common.inventory.DisguiseContainer;
import slimeknights.tmechworks.integration.waila.IInformationProvider;

public abstract class RedstoneMachineTileEntity
extends InventoryTileEntity
implements ITickableTileEntity,
IInformationProvider {
    private Inventory disguiseInventory = new Inventory(1){

        public boolean func_94041_b(int index, ItemStack stack) {
            return stack.func_77973_b() instanceof BlockItem;
        }

        public int func_70297_j_() {
            return 1;
        }
    };
    private String disguiseState;
    private int redstoneState;
    private boolean isFirstTick = true;

    public RedstoneMachineTileEntity(TileEntityType<?> type, ITextComponent name, int inventorySize) {
        this(type, name, inventorySize, 64);
    }

    public RedstoneMachineTileEntity(TileEntityType<?> type, ITextComponent name, int inventorySize, int maxStackSize) {
        super(type, name, inventorySize, maxStackSize);
    }

    public void updateRedstone() {
        if (this.isFirstTick) {
            return;
        }
        Direction facing = Direction.NORTH;
        if (this.hasFacingDirection()) {
            facing = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)RedstoneMachineBlock.field_176387_N);
        }
        int oldPow = this.redstoneState;
        Direction[] directions = Direction.values();
        int maxPow = 0;
        for (Direction dir : directions) {
            int pow;
            if (this.hasFacingDirection() && dir == facing || (pow = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir)) <= maxPow) continue;
            maxPow = pow;
        }
        int downPow = this.field_145850_b.func_175651_c(this.field_174879_c, Direction.DOWN);
        if (downPow > maxPow) {
            maxPow = downPow;
        }
        this.redstoneState = maxPow;
        if (maxPow != oldPow) {
            this.onRedstoneUpdate();
        }
        this.onBlockUpdate();
        if (oldPow != this.redstoneState) {
            this.sync();
        }
    }

    public void onRedstoneUpdate() {
    }

    public void onBlockUpdate() {
    }

    public int getRedstoneState() {
        return this.redstoneState;
    }

    public void func_73660_a() {
        if (this.isFirstTick) {
            this.isFirstTick = false;
            this.updateRedstone();
            this.init();
            this.sync();
        }
    }

    public void init() {
        this.disguiseInventory.func_110134_a(inv -> this.refreshDisguise());
    }

    public ItemStack getDisguiseBlock() {
        return this.disguiseInventory.func_70301_a(0);
    }

    public void setDisguiseBlock(ItemStack disguise) {
        this.disguiseInventory.func_70299_a(0, disguise);
    }

    public String getDisguiseState() {
        return this.disguiseState;
    }

    public void setDisguiseState(String state) {
        this.disguiseState = state;
        this.refreshDisguise();
    }

    public Inventory getDisguiseInventory() {
        return this.disguiseInventory;
    }

    public void refreshDisguise() {
        BlockState state;
        this.requestModelDataUpdate();
        this.markDirtyFast();
        BlockState from = state = this.func_195044_w();
        ItemStack item = this.getDisguiseBlock();
        boolean hasDisguise = !item.func_190926_b() && item.func_77973_b() instanceof BlockItem;
        state = (BlockState)state.func_206870_a((IProperty)RedstoneMachineBlock.HAS_DISGUISE, (Comparable)Boolean.valueOf(hasDisguise));
        if (hasDisguise) {
            BlockState disguiseState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
            state = (BlockState)state.func_206870_a((IProperty)RedstoneMachineBlock.LIGHT_VALUE, (Comparable)Integer.valueOf(Math.max(disguiseState.func_177230_c().getLightValue(disguiseState, (IBlockReader)this.func_145831_w(), this.func_174877_v()), disguiseState.func_177230_c().func_149750_m(disguiseState))));
        }
        this.func_145831_w().func_175656_a(this.func_174877_v(), state);
        this.func_145831_w().func_184138_a(this.func_174877_v(), from, state, 3);
        this.func_145831_w().func_225524_e_().func_215568_a(this.func_174877_v());
    }

    public CompoundNBT writeItemData(CompoundNBT tags) {
        ItemStack disguise;
        tags.func_74768_a("InventorySize", this.func_70302_i_());
        this.writeInventoryToNBT(tags);
        if (this.func_145818_k_()) {
            tags.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.inventoryTitle));
        }
        if (!(disguise = this.getDisguiseBlock()).func_190926_b()) {
            CompoundNBT itemNBT = new CompoundNBT();
            itemNBT = disguise.func_77955_b(itemNBT);
            tags.func_218657_a("Disguise", (INBT)itemNBT);
            if (this.disguiseState != null) {
                tags.func_74778_a("DisguiseState", this.disguiseState);
            }
        }
        return tags;
    }

    public void readItemData(CompoundNBT tags) {
        super.func_145839_a(tags);
        if (tags.func_74764_b("Disguise")) {
            CompoundNBT itemNBT = tags.func_74775_l("Disguise");
            ItemStack disguise = ItemStack.func_199557_a((CompoundNBT)itemNBT);
            if (tags.func_150297_b("DisguiseState", 8)) {
                this.disguiseState = tags.func_74779_i("DisguiseState");
            }
            this.setDisguiseBlock(disguise);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        tags = this.writeItemData(tags);
        tags.func_74768_a("Redstone", this.redstoneState);
        return tags;
    }

    public void func_145839_a(CompoundNBT tags) {
        this.readItemData(tags);
        this.redstoneState = tags.func_74762_e("Redstone");
    }

    public void writeInventoryToNBT(CompoundNBT tag) {
        if (!this.func_191420_l()) {
            super.writeInventoryToNBT(tag);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tags = new CompoundNBT();
        this.func_189515_b(tags);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tags);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tags = pkt.func_148857_g();
        this.handleUpdateTag(tags);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public void sync() {
        this.func_70296_d();
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            SUpdateTileEntityPacket packetUpdateTileEntity = this.func_189518_D_();
            if (packetUpdateTileEntity == null) {
                return;
            }
            for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)packetUpdateTileEntity);
            }
        }
    }

    public ItemStack storeTileData(ItemStack stack) {
        CompoundNBT tags = this.writeItemData(new CompoundNBT());
        stack.func_77983_a("BlockEntityTag", (INBT)tags);
        if (this.func_145818_k_()) {
            CompoundNBT name = new CompoundNBT();
            name.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.inventoryTitle));
            stack.func_77983_a("display", (INBT)name);
        }
        return stack;
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguiseBakedModel.DISGUISE, (Object)this.getDisguiseBlock()).withInitial(DisguiseBakedModel.DISGUISE_STATE, (Object)this.getDisguiseState()).build();
    }

    @Override
    public void getInformation(@Nonnull List<ITextComponent> info, IInformationProvider.InformationType type, PlayerEntity player) {
        if (type != IInformationProvider.InformationType.BODY) {
            return;
        }
        info.add((ITextComponent)new TranslationTextComponent("tooltip.waila.power", new Object[]{this.getRedstoneState()}));
    }

    @Override
    public void getInformation(@Nonnull List<ITextComponent> info, IInformationProvider.InformationType type, CompoundNBT serverData, PlayerEntity player) {
        this.getInformation(info, type, player);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new DisguiseContainer(id, playerInventory, this);
    }

    public final boolean hasFacingDirection() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() instanceof RedstoneMachineBlock) {
            return ((RedstoneMachineBlock)state.func_177230_c()).hasFacingDirection();
        }
        return state.func_196959_b((IProperty)DirectionalBlock.field_176387_N);
    }
}

