/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.api.ITileSortable;
import com.lothrazar.storagenetwork.api.data.EnumSortType;
import com.lothrazar.storagenetwork.item.remote.ItemRemote;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SortMessage {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;
    private boolean targetTileEntity;

    private SortMessage() {
    }

    public SortMessage(BlockPos pos, boolean direction, EnumSortType sort) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
    }

    public static void handle(SortMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (message.targetTileEntity) {
                TileEntity tileEntity = player.field_70170_p.func_175625_s(message.pos);
                if (tileEntity instanceof ITileSortable) {
                    ITileSortable tile = (ITileSortable)tileEntity;
                    tile.setSort(message.sort);
                    tile.setDownwards(message.direction);
                    tileEntity.func_70296_d();
                }
            } else {
                ItemStack stackPlayerHeld = player.field_71071_by.func_70448_g();
                if (stackPlayerHeld.func_77973_b() instanceof ItemRemote) {
                    ItemRemote.setSort(stackPlayerHeld, message.sort);
                    ItemRemote.setDownwards(stackPlayerHeld, message.direction);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static SortMessage decode(PacketBuffer buf) {
        SortMessage message = new SortMessage();
        message.direction = buf.readBoolean();
        int sort = buf.readInt();
        message.sort = EnumSortType.values()[sort];
        message.targetTileEntity = buf.readBoolean();
        message.pos = buf.func_179259_c();
        return message;
    }

    public static void encode(SortMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.direction);
        buf.writeInt(msg.sort.ordinal());
        if (msg.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(msg.pos);
        } else {
            buf.writeBoolean(false);
            buf.func_179255_a(BlockPos.field_177992_a);
        }
    }
}

