/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.export;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.block.cable.export.ContainerCableExportFilter;
import com.lothrazar.storagenetwork.gui.GuiButtonRequest;
import com.lothrazar.storagenetwork.gui.inventory.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.inventory.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.CableIOMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiCableExportFilter
extends ContainerScreen<ContainerCableExportFilter>
implements IGuiPrivate {
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable_filter.png");
    ContainerCableExportFilter containerCableLink;
    private GuiButtonRequest btnMinus;
    private GuiButtonRequest btnPlus;
    private GuiButtonRequest btnWhite;
    private GuiButtonRequest btnImport;
    private boolean isWhitelist;
    private List<ItemSlotNetwork> itemSlotsGhost;
    public static final int SLOT_SIZE = 18;

    public GuiCableExportFilter(ContainerCableExportFilter containerCableFilter, PlayerInventory inv, ITextComponent name) {
        super((Container)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    public void init() {
        super.init();
        this.isWhitelist = this.containerCableLink.cap.getFilter().isWhitelist;
        int x = this.field_147003_i + 7;
        int y = this.field_147009_r + 8;
        this.btnMinus = (GuiButtonRequest)this.addButton((Widget)new GuiButtonRequest(x, y, "-", p -> this.syncData(-1)));
        this.btnPlus = (GuiButtonRequest)this.addButton((Widget)new GuiButtonRequest(x += 30, y, "+", p -> this.syncData(1)));
        this.btnWhite = (GuiButtonRequest)this.addButton((Widget)new GuiButtonRequest(x += 20, y, "", p -> {
            this.isWhitelist = !this.isWhitelist;
            this.syncData(0);
        }));
        this.btnImport = (GuiButtonRequest)this.addButton((Widget)new GuiButtonRequest(x += 20, y, "", p -> this.importFilterSlots()));
        this.btnImport.setMessage("I");
    }

    private void importFilterSlots() {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.IMPORT_FILTER.ordinal()));
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    private void syncData(int priority) {
        this.containerCableLink.cap.getFilter().isWhitelist = this.isWhitelist;
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SYNC_DATA.ordinal(), priority, this.isWhitelist));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.containerCableLink == null || this.containerCableLink.cap == null) {
            return;
        }
        this.btnWhite.setTextureId(this.isWhitelist ? GuiButtonRequest.TextureEnum.WHITELIST : GuiButtonRequest.TextureEnum.BLACKLIST);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int priority = this.containerCableLink.cap.getPriority();
        this.font.func_211126_b(String.valueOf(priority), (float)(30 - this.font.func_78256_a(String.valueOf(priority)) / 2), 14.0f, 0x404040);
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawTooltips(int mouseX, int mouseY) {
        if (this.btnImport != null && this.btnImport.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.import", (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.btnWhite != null && this.btnWhite.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)(this.isWhitelist ? "gui.storagenetwork.gui.whitelist" : "gui.storagenetwork.gui.blacklist"), (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.btnMinus != null && this.btnMinus.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.priority.down", (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.btnPlus != null && this.btnPlus.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.priority.up", (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.texture);
        int xCenter = (this.width - this.field_146999_f) / 2;
        int yCenter = (this.height - this.field_147000_g) / 2;
        this.blit(xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 35;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, stack.func_190916_E(), this.field_147003_i, this.field_147009_r, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(this.font, mouseX, mouseY);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        ItemStack mouse = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().func_190926_b()) {
                if (mouseButton == 1) {
                    int direction = this.hasShiftDown() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().func_190916_E() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().func_190920_e(newCount);
                } else {
                    slot.setStack(ItemStack.field_190927_a);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            slot.setStack(mouse.func_77946_l());
            this.sendStackSlot(i, mouse.func_77946_l());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void renderStackToolTip(ItemStack stack, int x, int y) {
        super.renderTooltip(stack, x, y);
    }

    @Override
    public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.fillGradient(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY);
    }
}

