/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.part;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.capability.EnergyStorageItemImpl;
import net.silentchaos512.supermultidrills.init.ModItems;
import net.silentchaos512.supermultidrills.item.DrillItem;

public class BatteryPart
extends AbstractGearPart
implements IUpgradePart {
    private static final ResourceLocation TYPE_ID = SuperMultiDrills.getId("battery");
    public static final PartType TYPE = PartType.create((ResourceLocation)TYPE_ID, (IPartSerializer)new AbstractGearPart.Serializer(TYPE_ID, BatteryPart::new));
    public static final IPartPosition POSITION = new IPartPosition(){

        public String getTexturePrefix() {
            return "battery";
        }

        public String getModelIndex() {
            return "battery";
        }
    };

    public BatteryPart(ResourceLocation partId) {
        super(partId);
    }

    public PartType getType() {
        return TYPE;
    }

    public IPartPosition getPartPosition() {
        return POSITION;
    }

    public IPartSerializer<?> getSerializer() {
        return TYPE.getSerializer();
    }

    public boolean isValidFor(ICoreItem gearItem) {
        return gearItem instanceof DrillItem;
    }

    public boolean replacesExisting() {
        return true;
    }

    public ITextComponent getDisplayName(@Nullable PartData part, ItemStack gear) {
        if (part != null) {
            return part.getCraftingItem().func_200301_q();
        }
        return super.getDisplayName(null, gear);
    }

    public void onAddToGear(ItemStack gear, ItemStack part) {
        if (!(gear.func_77973_b() instanceof DrillItem)) {
            return;
        }
        IEnergyStorage partEnergy = (IEnergyStorage)part.getCapability(CapabilityEnergy.ENERGY).orElse((Object)new EnergyStorageItemImpl(part, 1000000, 1000, 1000));
        DrillItem.setBatteryCapacity(gear, partEnergy.getMaxEnergyStored());
        LazyOptional gearOptional = gear.getCapability(CapabilityEnergy.ENERGY);
        if (gearOptional.isPresent()) {
            IEnergyStorage gearEnergy = (IEnergyStorage)gearOptional.orElseThrow(IllegalStateException::new);
            if (gearEnergy instanceof EnergyStorageItemImpl) {
                EnergyStorageItemImpl gearEnergyImpl = (EnergyStorageItemImpl)gearEnergy;
                gearEnergyImpl.setEnergyStored(partEnergy.getEnergyStored());
            }
        } else {
            SuperMultiDrills.LOGGER.catching((Throwable)new NullPointerException("Either drill or battery is missing its energy capability"));
        }
    }

    public void onRemoveFromGear(ItemStack gear, PartData part) {
        gear.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> part.getCraftingItem().getCapability(CapabilityEnergy.ENERGY).ifPresent(partEnergy -> {
            if (partEnergy instanceof EnergyStorageItemImpl) {
                ((EnergyStorageItemImpl)((Object)((Object)partEnergy))).setEnergyStored(e.getEnergyStored());
            }
        }));
    }

    public PartData randomizeData() {
        int batteriesCount = ModItems.BATTERIES.size();
        int index = MathHelper.func_76125_a((int)(1 + SuperMultiDrills.random.nextInt(batteriesCount)), (int)2, (int)(batteriesCount - 1));
        ItemStack stack = new ItemStack((IItemProvider)ModItems.BATTERIES.get(index));
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
            if (e instanceof EnergyStorageItemImpl) {
                ((EnergyStorageItemImpl)((Object)e)).setEnergyStored(e.getMaxEnergyStored());
            }
        });
        return PartData.of((IGearPart)this, (ItemStack)stack);
    }
}

