/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public class BigItemStack {
    public int stackSize = 0;
    private final ItemStack baseStack;

    public BigItemStack(ItemStack stack) {
        this.baseStack = stack.func_77946_l();
        this.stackSize = this.baseStack.func_190916_E();
        this.baseStack.func_190920_e(1);
    }

    public BigItemStack(Block block) {
        this(block, 1);
    }

    public BigItemStack(Block block, int amount) {
        this(block.func_199767_j(), amount);
    }

    public BigItemStack(Item item) {
        this(item, 1);
    }

    public BigItemStack(Item item, int amount) {
        this.baseStack = new ItemStack((IItemProvider)item, 1);
        this.stackSize = amount;
    }

    public ItemStack getBaseStack() {
        return this.baseStack;
    }

    public CompoundNBT GetTagCompound() {
        return this.baseStack.func_77978_p();
    }

    public void SetTagCompound(CompoundNBT tags) {
        this.baseStack.func_77982_d(tags);
    }

    public boolean HasTagCompound() {
        return this.baseStack.func_77942_o();
    }

    public List<ItemStack> getCombinedStacks() {
        int size;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int tmp1 = Math.max(1, this.stackSize); tmp1 > 0; tmp1 -= size) {
            size = Math.min(tmp1, this.baseStack.func_77976_d());
            ItemStack stack = this.baseStack.func_77946_l();
            stack.func_190920_e(size);
            list.add(stack);
        }
        return list;
    }

    public BigItemStack copy() {
        BigItemStack stack = new BigItemStack(this.baseStack.func_77946_l());
        stack.stackSize = this.stackSize;
        return stack;
    }

    public boolean equals(Object stack) {
        if (stack instanceof ItemStack) {
            return this.baseStack.func_77969_a((ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.baseStack, (ItemStack)((ItemStack)stack));
        }
        return super.equals(stack);
    }

    public BigItemStack(CompoundNBT tags) {
        CompoundNBT itemNBT = tags.func_74737_b();
        itemNBT.func_74768_a("Count", 1);
        if (tags.func_150297_b("id", 99)) {
            itemNBT.func_74778_a("id", "" + tags.func_74765_d("id"));
        }
        this.stackSize = tags.func_74762_e("Count");
        this.baseStack = ItemStack.func_199557_a((CompoundNBT)itemNBT);
    }

    public CompoundNBT writeToNBT(CompoundNBT tags) {
        this.baseStack.func_77955_b(tags);
        tags.func_74768_a("Count", this.stackSize);
        return tags;
    }
}

