/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.TagIngredient;
import org.apache.logging.log4j.Level;

public class ItemEntry {
    public final boolean isWildcard;
    public final ResourceLocation idName;
    public final TagIngredient tagIng;

    public ItemEntry() {
        this.idName = null;
        this.tagIng = null;
        this.isWildcard = true;
    }

    public ItemEntry(ResourceLocation idName) {
        this.idName = idName;
        this.tagIng = null;
        this.isWildcard = false;
    }

    public ItemEntry(String tagName) {
        this.tagIng = StringUtils.func_151246_b((String)tagName) ? null : new TagIngredient(tagName);
        this.idName = null;
        this.isWildcard = false;
    }

    public boolean checkMatch(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (this.isWildcard) {
            return true;
        }
        if (this.tagIng != null && this.tagIng.apply(stack)) {
            return true;
        }
        return this.idName != null && this.idName.equals((Object)stack.func_77973_b().getRegistryName());
    }

    public static ItemEntry readFromString(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.equalsIgnoreCase("*")) {
            return new ItemEntry();
        }
        String[] split = s.split(":");
        if (split.length <= 1 || split.length > 3) {
            OreExcavation.logger.log(Level.WARN, "Invalid Item Entry format: " + s);
            return null;
        }
        if (split.length == 2) {
            return new ItemEntry(new ResourceLocation(split[0], split[1]));
        }
        if (s.startsWith("tag:")) {
            return new ItemEntry(s.replaceFirst("tag:", ""));
        }
        OreExcavation.logger.log(Level.WARN, "Invalid Item Entry format: " + s);
        return null;
    }
}

