/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.world;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChunkCache
extends Region
implements IWorldReader {
    protected int field_72818_a;
    protected int field_72816_b;
    protected Chunk[][] chunkArray;
    protected boolean field_72814_d;
    protected World field_72815_e;

    public ChunkCache(World worldIn, BlockPos posFromIn, BlockPos posToIn) {
        super(worldIn, BlockPos.field_177992_a, BlockPos.field_177992_a);
        this.field_72815_e = worldIn;
        this.field_72818_a = posFromIn.func_177958_n() >> 4;
        this.field_72816_b = posFromIn.func_177952_p() >> 4;
        int i = posToIn.func_177958_n() >> 4;
        int j = posToIn.func_177952_p() >> 4;
        this.chunkArray = new Chunk[i - this.field_72818_a + 1][j - this.field_72816_b + 1];
        this.field_72814_d = true;
        for (int k = this.field_72818_a; k <= i; ++k) {
            for (int l = this.field_72816_b; l <= j; ++l) {
                if (!worldIn.func_72863_F().func_222865_a(new ChunkPos(k, l))) continue;
                this.chunkArray[k - this.field_72818_a][l - this.field_72816_b] = worldIn.func_212866_a_(k, l);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmpty() {
        return this.field_72814_d;
    }

    @Nullable
    public TileEntity func_175625_s(@NotNull BlockPos pos) {
        return this.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
    }

    public IBlockReader func_225522_c_(int p_225522_1_, int p_225522_2_) {
        if (!this.withinBounds(p_225522_1_, p_225522_2_)) {
            return null;
        }
        return this.chunkArray[p_225522_1_][p_225522_2_];
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, Chunk.CreateEntityType createType) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.field_72816_b)) {
            return null;
        }
        return this.chunkArray[i][j].func_177424_a(pos, createType);
    }

    @NotNull
    public BlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.func_180495_p(pos);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public IFluidState func_204610_c(BlockPos pos) {
        Chunk chunk;
        if (World.func_189509_E((BlockPos)pos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
        int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
        if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
            return chunk.func_204610_c(pos);
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Biome func_226691_t_(BlockPos pos) {
        return Biomes.field_76772_c;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return null;
    }

    public boolean func_175623_d(BlockPos pos) {
        BlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockReader)this, pos);
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return null;
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        return false;
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return null;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return 0;
    }

    public int func_175657_ab() {
        return 0;
    }

    public BiomeManager func_225523_d_() {
        return null;
    }

    public WorldBorder func_175723_af() {
        return null;
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return false;
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public boolean func_201670_d() {
        return false;
    }

    public int func_181545_F() {
        return 0;
    }

    public Dimension func_201675_m() {
        return null;
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }

    public WorldLightManager func_225524_e_() {
        return null;
    }
}

