/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.customEntities;

import com.google.common.collect.ImmutableSet;
import com.performant.coremod.entity.customEntities.ModEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class PerformantZombie
extends ZombieEntity {
    private int tickCounter = 0;
    private static final double MOTION_MULT_LENGHT = 1.0E-7;
    boolean lastHandleWaterMovement = false;
    boolean isInWaterRainOrBubbleColumn = false;
    boolean lastIsEntityInsideOpaqueBlock = false;
    boolean isFlammableWithin = false;
    Vec3d lastHeuristicVector = Vec3d.field_186680_a;
    Vec3d lastHeuristicResult = Vec3d.field_186680_a;
    List<VoxelShape> entityCollisionBoxes = new ArrayList<VoxelShape>();
    boolean isOffsetPosInLiquidres = false;
    float lastSpeedFactor = 1.0f;
    boolean lastIsOnLadder = false;
    boolean areEyesInFluid = false;

    public PerformantZombie(EntityType<? extends ZombieEntity> p_i48549_1_, World world) {
        super(ModEntities.PERFORMANT_ZOMBIE, world);
    }

    public PerformantZombie(World worldIn) {
        this(ModEntities.PERFORMANT_ZOMBIE, worldIn);
    }

    public PerformantZombie() {
        super(ModEntities.PERFORMANT_ZOMBIE, null);
    }

    public static void init() {
        EntityType.field_200725_aD.field_200732_aK = PerformantZombie::new;
        ModEntities.PERFORMANT_ZOMBIE = EntityType.Builder.func_220322_a(PerformantZombie::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_206830_a("minecraft:zombie");
        ModEntities.PERFORMANT_ZOMBIE.setRegistryName(new ResourceLocation("minecraft:zombie"));
    }

    public void func_70071_h_() {
        if (this.tickCounter++ == 100) {
            this.tickCounter = 0;
        }
        super.func_70071_h_();
    }

    public void func_213315_a(MoverType typeIn, Vec3d pos) {
        Vec3d vec3d;
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(pos));
            this.func_174829_m();
            return;
        }
        if (typeIn == MoverType.PISTON && (pos = this.func_213308_a(pos)).equals((Object)Vec3d.field_186680_a)) {
            return;
        }
        this.field_70170_p.func_217381_Z().func_76320_a("move");
        if (this.field_213328_B.func_189985_c() > 1.0E-7) {
            pos = pos.func_216369_h(this.field_213328_B);
            this.field_213328_B = Vec3d.field_186680_a;
            this.func_213317_d(Vec3d.field_186680_a);
        }
        if ((vec3d = this.getAllowedMovement(pos)).func_189985_c() > 1.0E-7) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(vec3d));
            this.func_174829_m();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("rest");
        this.field_70123_F = !MathHelper.func_219806_b((double)pos.field_72450_a, (double)vec3d.field_72450_a) || !MathHelper.func_219806_b((double)pos.field_72449_c, (double)vec3d.field_72449_c);
        this.field_70124_G = pos.field_72448_b != vec3d.field_72448_b;
        this.field_70122_E = this.field_70124_G && pos.field_72448_b < 0.0;
        this.field_70132_H = this.field_70123_F || this.field_70124_G;
        this.updateFallState(vec3d, pos);
        Vec3d vec3d1 = this.func_213322_ci();
        if (pos.field_72450_a != vec3d.field_72450_a) {
            this.func_213293_j(0.0, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }
        if (pos.field_72449_c != vec3d.field_72449_c) {
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b, 0.0);
        }
        this.checkFireArea();
        this.checkBlockCollisions();
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)this.func_225515_ai_(), 1.0, (double)this.func_225515_ai_()));
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    private void updateFallState(Vec3d movementVec, Vec3d pos) {
        BlockPos blockpos = this.func_226268_ag_();
        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        this.func_184231_a(movementVec.field_72448_b, this.field_70122_E, blockstate, blockpos);
        Block block = blockstate.func_177230_c();
        if (pos.field_72448_b != movementVec.field_72448_b) {
            block.func_176216_a((IBlockReader)this.field_70170_p, (Entity)this);
        }
        if (this.field_70122_E && !this.func_226271_bk_()) {
            block.func_176199_a(this.field_70170_p, blockpos, (Entity)this);
        }
        if (this.func_225502_at_() && !this.func_184218_aH()) {
            double d0 = movementVec.field_72450_a;
            double d1 = movementVec.field_72448_b;
            double d2 = movementVec.field_72449_c;
            if (block != Blocks.field_150468_ap && block != Blocks.field_222420_lI) {
                d1 = 0.0;
            }
            this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)PerformantZombie.func_213296_b((Vec3d)movementVec)) * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2)) * 0.6);
            if (this.field_82151_R > this.field_70150_b && !blockstate.isAir((IBlockReader)this.field_70170_p, blockpos)) {
                this.field_70150_b = this.func_203009_ad();
                if (this.func_70090_H()) {
                    PerformantZombie entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                    float f = entity == this ? 0.35f : 0.4f;
                    Vec3d vec3d2 = entity.func_213322_ci();
                    float f1 = MathHelper.func_76133_a((double)(vec3d2.field_72450_a * vec3d2.field_72450_a * (double)0.2f + vec3d2.field_72448_b * vec3d2.field_72448_b + vec3d2.field_72449_c * vec3d2.field_72449_c * (double)0.2f)) * f;
                    if (f1 > 1.0f) {
                        f1 = 1.0f;
                    }
                    this.func_203006_d(f1);
                } else {
                    this.func_180429_a(blockpos, blockstate);
                }
            } else if (this.field_82151_R > this.field_191959_ay && this.func_191957_ae() && blockstate.isAir((IBlockReader)this.field_70170_p, blockpos)) {
                this.field_191959_ay = this.func_191954_d(this.field_82151_R);
            }
        }
    }

    public boolean func_70072_I() {
        if (this.tickCounter % 5 != 0) {
            return this.lastHandleWaterMovement;
        }
        if (this.func_184187_bx() instanceof BoatEntity) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b(FluidTags.field_206959_a)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        this.lastHandleWaterMovement = this.field_70171_ac;
        return this.lastHandleWaterMovement;
    }

    public boolean func_203008_ap() {
        if (this.tickCounter % 5 != 0) {
            return this.isInWaterRainOrBubbleColumn;
        }
        this.isInWaterRainOrBubbleColumn = super.func_203008_ap();
        return this.isInWaterRainOrBubbleColumn;
    }

    public boolean func_70094_T() {
        if (this.tickCounter % 5 != 0) {
            return this.lastIsEntityInsideOpaqueBlock;
        }
        this.lastIsEntityInsideOpaqueBlock = super.func_70094_T();
        return this.lastIsEntityInsideOpaqueBlock;
    }

    private void checkFireArea() {
        if (this.tickCounter % 5 == 0) {
            this.isFlammableWithin = this.field_70170_p.func_147470_e(this.func_174813_aQ().func_186664_h(0.001));
        }
        if (this.isFlammableWithin) {
            if (!this.func_203008_ap()) {
                ++this.field_190534_ay;
                if (this.field_190534_ay == 0) {
                    this.func_70015_d(8);
                }
            }
            this.func_70081_e(1);
        } else if (this.field_190534_ay <= 0) {
            this.field_190534_ay = -this.func_190531_bD();
        }
        if (this.isInWaterRainOrBubbleColumn && this.func_70027_ad()) {
            this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            this.field_190534_ay = -this.func_190531_bD();
        }
    }

    private void checkBlockCollisions() {
        this.field_213329_S = false;
        if (this.tickCounter % 5 == 0) {
            this.func_145775_I();
        }
    }

    private Vec3d getAllowedMovement(Vec3d vec) {
        boolean flag3;
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
        ArrayList<VoxelShape> entityVoxelShapes = new ArrayList<VoxelShape>();
        if (vec.field_72450_a != 0.0 || vec.field_72449_c != 0.0) {
            entityVoxelShapes.addAll(this.getEntityCollisionBoxes((Entity)this, boundingBox.func_216361_a(vec), (Set<Entity>)ImmutableSet.of()));
        }
        Vec3d vec3d = vec.func_189985_c() == 0.0 ? vec : this.collideBoundingBoxHeuristically((Entity)this, vec, boundingBox, this.field_70170_p, iselectioncontext, entityVoxelShapes);
        boolean flag = vec.field_72450_a != vec3d.field_72450_a;
        boolean flag1 = vec.field_72448_b != vec3d.field_72448_b;
        boolean flag2 = vec.field_72449_c != vec3d.field_72449_c;
        boolean bl = flag3 = this.field_70122_E || flag1 && vec.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vec3d vec3d3;
            Vec3d vec3d1 = this.collideBoundingBoxHeuristically((Entity)this, new Vec3d(vec.field_72450_a, (double)this.field_70138_W, vec.field_72449_c), boundingBox, this.field_70170_p, iselectioncontext, entityVoxelShapes);
            Vec3d vec3d2 = this.collideBoundingBoxHeuristically((Entity)this, new Vec3d(0.0, (double)this.field_70138_W, 0.0), boundingBox.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), this.field_70170_p, iselectioncontext, entityVoxelShapes);
            if (vec3d2.field_72448_b < (double)this.field_70138_W && PerformantZombie.func_213296_b((Vec3d)(vec3d3 = this.collideBoundingBoxHeuristically((Entity)this, new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c), boundingBox.func_191194_a(vec3d2), this.field_70170_p, iselectioncontext, entityVoxelShapes).func_178787_e(vec3d2))) > PerformantZombie.func_213296_b((Vec3d)vec3d1)) {
                vec3d1 = vec3d3;
            }
            if (PerformantZombie.func_213296_b((Vec3d)vec3d1) > PerformantZombie.func_213296_b((Vec3d)vec3d)) {
                return vec3d1.func_178787_e(this.collideBoundingBoxHeuristically((Entity)this, new Vec3d(0.0, -vec3d1.field_72448_b + vec.field_72448_b, 0.0), boundingBox.func_191194_a(vec3d1), this.field_70170_p, iselectioncontext, entityVoxelShapes));
            }
        }
        return vec3d;
    }

    public Vec3d collideBoundingBoxHeuristically(@Nullable Entity entity, Vec3d vec3d, AxisAlignedBB axisAlignedBB, World world, ISelectionContext iSelectionContext, List<VoxelShape> entityVoxelShapes) {
        if (this.field_70122_E && this.tickCounter % 10 != 0 && this.lastHeuristicResult != Vec3d.field_186680_a && this.lastHeuristicVector.equals((Object)vec3d)) {
            return this.lastHeuristicResult;
        }
        this.lastHeuristicVector = vec3d;
        boolean hasXMovement = vec3d.field_72450_a != 0.0;
        boolean hasYMovement = vec3d.field_72448_b != 0.0;
        boolean hasZMovement = vec3d.field_72449_c != 0.0;
        this.lastHeuristicResult = !(!hasXMovement && !hasYMovement || !hasXMovement && !hasZMovement || !hasYMovement && !hasZMovement) ? PerformantZombie.collideBoundingBoxSingle(entity, vec3d, axisAlignedBB, entityVoxelShapes) : PerformantZombie.getAllowedMovement(vec3d, axisAlignedBB, (IWorldReader)world, iSelectionContext, entityVoxelShapes);
        return this.lastHeuristicResult;
    }

    public static Vec3d collideBoundingBoxSingle(Entity entity, Vec3d vec3d, AxisAlignedBB axisAlignedBB, List<VoxelShape> entityCollisionBoxes) {
        boolean flag;
        AxisAlignedBB expandedaxisAlignedBB = axisAlignedBB.func_216361_a(vec3d);
        int minX = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72334_f + 1.0E-7)) + 1;
        ISelectionContext iselectioncontext = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        VoxelShape entityVoxelShape = VoxelShapes.func_197881_a((AxisAlignedBB)expandedaxisAlignedBB);
        ArrayList<VoxelShape> allCollisionShapes = new ArrayList<VoxelShape>(entityCollisionBoxes);
        PerformantZombie.addShapesForBlockCollision(allCollisionShapes, cubecoordinateiterator, blockpos$mutable, entity.field_70170_p, iselectioncontext, entityVoxelShape);
        double xMotion = vec3d.field_72450_a;
        double yMotion = vec3d.field_72448_b;
        double zMotion = vec3d.field_72449_c;
        if (yMotion != 0.0 && (yMotion = PerformantZombie.getAllowedOffset(Direction.Axis.Y, axisAlignedBB, allCollisionShapes, yMotion)) != 0.0) {
            axisAlignedBB = axisAlignedBB.func_72317_d(0.0, yMotion, 0.0);
        }
        boolean bl = flag = Math.abs(xMotion) < Math.abs(zMotion);
        if (flag && zMotion != 0.0 && (zMotion = PerformantZombie.getAllowedOffset(Direction.Axis.Z, axisAlignedBB, allCollisionShapes, zMotion)) != 0.0) {
            axisAlignedBB = axisAlignedBB.func_72317_d(0.0, 0.0, zMotion);
        }
        if (xMotion != 0.0) {
            xMotion = PerformantZombie.getAllowedOffset(Direction.Axis.X, axisAlignedBB, allCollisionShapes, xMotion);
            if (!flag && xMotion != 0.0) {
                axisAlignedBB = axisAlignedBB.func_72317_d(xMotion, 0.0, 0.0);
            }
        }
        if (!flag && zMotion != 0.0) {
            zMotion = PerformantZombie.getAllowedOffset(Direction.Axis.Z, axisAlignedBB, allCollisionShapes, zMotion);
        }
        return new Vec3d(xMotion, yMotion, zMotion);
    }

    public static double getAllowedOffset(Direction.Axis axis, AxisAlignedBB bb, List<VoxelShape> collisionShapes, double offSet) {
        Iterator<VoxelShape> iterator = collisionShapes.iterator();
        while (iterator.hasNext()) {
            if (Math.abs(offSet) < 1.0E-7) {
                return 0.0;
            }
            offSet = iterator.next().func_212430_a(axis, bb, offSet);
        }
        return offSet;
    }

    private static void addShapesForBlockCollision(List<VoxelShape> shapeCollisionList, CubeCoordinateIterator cubeToCheck, BlockPos.Mutable mutablePos, World world, ISelectionContext iselectioncontext, VoxelShape voxelShapeToCheckForCollisions) {
        while (cubeToCheck.func_218301_a()) {
            VoxelShape voxelshape2;
            VoxelShape nextShape;
            int chunkZ;
            int chunkX;
            IBlockReader iblockreader;
            int coordX = cubeToCheck.func_218304_b();
            int coordY = cubeToCheck.func_218302_c();
            int coordZ = cubeToCheck.func_218303_d();
            int numBoundariesTouched = cubeToCheck.func_223473_e();
            if (numBoundariesTouched == 3 || (iblockreader = world.func_225522_c_(chunkX = coordX >> 4, chunkZ = coordZ >> 4)) == null) continue;
            mutablePos.func_181079_c(coordX, coordY, coordZ);
            BlockState blockstate = iblockreader.func_180495_p((BlockPos)mutablePos);
            if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb || !VoxelShapes.func_197879_c((VoxelShape)voxelShapeToCheckForCollisions, (VoxelShape)(nextShape = (voxelshape2 = blockstate.func_215685_b((IBlockReader)world, (BlockPos)mutablePos, iselectioncontext)).func_197751_a((double)coordX, (double)coordY, (double)coordZ)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            shapeCollisionList.add(nextShape);
        }
    }

    public static Vec3d getAllowedMovement(Vec3d vec, AxisAlignedBB collisionBox, IWorldReader worldIn, ISelectionContext selectionContext, List<VoxelShape> potentialHits) {
        boolean flag;
        double xMotion = vec.field_72450_a;
        double yMotion = vec.field_72448_b;
        double zMotion = vec.field_72449_c;
        if (yMotion != 0.0 && (yMotion = PerformantZombie.getAllowedOffset(Direction.Axis.Y, collisionBox, worldIn, yMotion, selectionContext, potentialHits)) != 0.0) {
            collisionBox = collisionBox.func_72317_d(0.0, yMotion, 0.0);
        }
        boolean bl = flag = Math.abs(xMotion) < Math.abs(zMotion);
        if (flag && zMotion != 0.0 && (zMotion = PerformantZombie.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, zMotion, selectionContext, potentialHits)) != 0.0) {
            collisionBox = collisionBox.func_72317_d(0.0, 0.0, zMotion);
        }
        if (xMotion != 0.0) {
            xMotion = PerformantZombie.getAllowedOffset(Direction.Axis.X, collisionBox, worldIn, xMotion, selectionContext, potentialHits);
            if (!flag && xMotion != 0.0) {
                collisionBox = collisionBox.func_72317_d(xMotion, 0.0, 0.0);
            }
        }
        if (!flag && zMotion != 0.0) {
            zMotion = PerformantZombie.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, zMotion, selectionContext, potentialHits);
        }
        return new Vec3d(xMotion, yMotion, zMotion);
    }

    public static double getAllowedOffset(Direction.Axis p_216383_0_, AxisAlignedBB p_216383_1_, IWorldReader p_216383_2_, double p_216383_3_, ISelectionContext p_216383_5_, List<VoxelShape> p_216383_6_) {
        return PerformantZombie.getAllowedOffset(p_216383_1_, p_216383_2_, p_216383_3_, p_216383_5_, AxisRotation.func_197516_a((Direction.Axis)p_216383_0_, (Direction.Axis)Direction.Axis.Z), p_216383_6_);
    }

    private static double getAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext selectionContext, AxisRotation rotationAxis, List<VoxelShape> possibleHits) {
        if (!(collisionBox.func_216364_b() < 1.0E-6 || collisionBox.func_216360_c() < 1.0E-6 || collisionBox.func_216362_d() < 1.0E-6)) {
            if (Math.abs(desiredOffset) < 1.0E-7) {
                return 0.0;
            }
            AxisRotation axisrotation = rotationAxis.func_197514_a();
            Direction.Axis direction$axis = axisrotation.func_197513_a(Direction.Axis.X);
            Direction.Axis direction$axis1 = axisrotation.func_197513_a(Direction.Axis.Y);
            Direction.Axis direction$axis2 = axisrotation.func_197513_a(Direction.Axis.Z);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis) - 1.0E-7)) - 1;
            int j = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis) + 1.0E-7)) + 1;
            int k = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis1) - 1.0E-7)) - 1;
            int l = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis1) + 1.0E-7)) + 1;
            double d0 = collisionBox.func_197745_a(direction$axis2) - 1.0E-7;
            double d1 = collisionBox.func_197742_b(direction$axis2) + 1.0E-7;
            boolean flag = desiredOffset > 0.0;
            int i1 = flag ? MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis2) - 1.0E-7)) - 1 : MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis2) + 1.0E-7)) + 1;
            int j1 = PerformantZombie.getDifferenceFloored(desiredOffset, d0, d1);
            int k1 = flag ? 1 : -1;
            int l1 = i1;
            while (!(flag ? l1 > j1 : l1 < j1)) {
                for (int i2 = i; i2 <= j; ++i2) {
                    for (int j2 = k; j2 <= l; ++j2) {
                        int k2 = 0;
                        if (i2 == i || i2 == j) {
                            ++k2;
                        }
                        if (j2 == k || j2 == l) {
                            ++k2;
                        }
                        if (l1 == i1 || l1 == j1) {
                            ++k2;
                        }
                        if (k2 >= 3) continue;
                        blockpos$mutable.func_218295_a(axisrotation, i2, j2, l1);
                        BlockState blockstate = worldReader.func_180495_p((BlockPos)blockpos$mutable);
                        if (k2 == 1 && !blockstate.func_215704_f() || k2 == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb) continue;
                        desiredOffset = blockstate.func_215685_b((IBlockReader)worldReader, (BlockPos)blockpos$mutable, selectionContext).func_212430_a(direction$axis2, collisionBox.func_72317_d((double)(-blockpos$mutable.func_177958_n()), (double)(-blockpos$mutable.func_177956_o()), (double)(-blockpos$mutable.func_177952_p())), desiredOffset);
                        if (Math.abs(desiredOffset) < 1.0E-7) {
                            return 0.0;
                        }
                        j1 = PerformantZombie.getDifferenceFloored(desiredOffset, d0, d1);
                    }
                }
                l1 += k1;
            }
            for (VoxelShape shape : possibleHits) {
                desiredOffset = shape.func_212430_a(direction$axis2, collisionBox, desiredOffset);
            }
            return desiredOffset;
        }
        return desiredOffset;
    }

    private static int getDifferenceFloored(double desiredOffset, double min, double max) {
        return desiredOffset > 0.0 ? MathHelper.func_76128_c((double)(max + desiredOffset)) + 1 : MathHelper.func_76128_c((double)(min + desiredOffset)) - 1;
    }

    private List<VoxelShape> getEntityCollisionBoxes(@Nullable Entity entity, AxisAlignedBB boundingBox, Set<Entity> excludedEntities) {
        if (boundingBox.func_72320_b() < 1.0E-7) {
            this.entityCollisionBoxes = new ArrayList<VoxelShape>();
            return new ArrayList<VoxelShape>();
        }
        if (this.tickCounter % 5 != 0) {
            return this.entityCollisionBoxes;
        }
        ArrayList<VoxelShape> result = new ArrayList<VoxelShape>();
        AxisAlignedBB grownBB = boundingBox.func_186662_g(1.0E-7);
        for (Entity currentEntity : this.field_70170_p.func_72839_b(entity, grownBB)) {
            AxisAlignedBB currentCBB;
            if (currentEntity == null || entity != null && entity.func_184223_x(currentEntity) || excludedEntities.contains(currentEntity) || (currentCBB = currentEntity.func_70046_E()) == null || !grownBB.func_72326_a(currentCBB)) continue;
            result.add(VoxelShapes.func_197881_a((AxisAlignedBB)currentCBB));
        }
        this.entityCollisionBoxes = result;
        return result;
    }

    public boolean func_70038_c(double x, double y, double z) {
        if (x == 0.0 && z == 0.0 && this.tickCounter % 20 != 0) {
            return this.isOffsetPosInLiquidres;
        }
        this.isOffsetPosInLiquidres = super.func_70038_c(x, y, z);
        return this.isOffsetPosInLiquidres;
    }

    protected float func_225515_ai_() {
        if (this.tickCounter % 5 != 0) {
            return this.lastSpeedFactor;
        }
        Block block = this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_177230_c();
        float f = block.func_226891_m_();
        this.lastSpeedFactor = block != Blocks.field_150355_j && block != Blocks.field_203203_C ? ((double)f == 1.0 ? this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_177230_c().func_226891_m_() : f) : f;
        return this.lastSpeedFactor;
    }

    public boolean func_70617_f_() {
        if (this.func_175149_v()) {
            return false;
        }
        if (this.tickCounter % 5 != 0) {
            return this.lastIsOnLadder;
        }
        BlockState blockstate = this.func_213339_cH();
        this.lastIsOnLadder = ForgeHooks.isLivingOnLadder((BlockState)blockstate, (World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this), (LivingEntity)this);
        return this.lastIsOnLadder;
    }

    protected void func_85033_bc() {
        if (this.tickCounter % 10 != 0) {
            return;
        }
        super.func_85033_bc();
    }

    public boolean func_213290_a(Tag<Fluid> p_213290_1_, boolean checkChunkLoaded) {
        if (this.tickCounter % 10 != 0) {
            return this.areEyesInFluid;
        }
        this.areEyesInFluid = super.func_213290_a(p_213290_1_, checkChunkLoaded);
        return this.areEyesInFluid;
    }

    public void func_205343_av() {
        if (this.tickCounter % 5 != 0) {
            return;
        }
        super.func_205343_av();
    }
}

