/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration {
    public final ForgeConfigSpec.IntValue goalSelectorTickRate;
    public final ForgeConfigSpec.BooleanValue optimizeTempt;
    public final ForgeConfigSpec.BooleanValue optimizeAvoid;
    public final ForgeConfigSpec.BooleanValue TELoadBalancing;
    public final ForgeConfigSpec.BooleanValue eventLoadBalancing;
    public final ForgeConfigSpec.BooleanValue optimizeHurtByTarget;
    public final ForgeConfigSpec.BooleanValue fastChunkBlocks;
    public final ForgeConfigSpec.BooleanValue optimizePanic;
    public final ForgeConfigSpec.BooleanValue optimizeBreed;
    public final ForgeConfigSpec.BooleanValue TEUnloadLag;
    public final ForgeConfigSpec.BooleanValue fastCollisions;
    public final ForgeConfigSpec.BooleanValue fastPathFind;
    public final ForgeConfigSpec.BooleanValue fastSpawnRadius;
    public final ForgeConfigSpec.BooleanValue noLagItemPickup;
    public final ForgeConfigSpec.BooleanValue fastItems;
    public final ForgeConfigSpec.BooleanValue fixLeash;
    public final ForgeConfigSpec.BooleanValue slowFindShelter;
    public final ForgeConfigSpec.BooleanValue betterRandomWalking;
    public final ForgeConfigSpec.BooleanValue AILoadBalancing;
    public final ForgeConfigSpec.BooleanValue TEDebugOutput;
    public final ForgeConfigSpec.BooleanValue eventDebugOutput;
    public final ForgeConfigSpec.BooleanValue logEntityAILag;
    public final ForgeConfigSpec.BooleanValue fastInventoryAdvancement;
    public final ForgeConfigSpec.IntValue meanTickAITH;
    public final ForgeConfigSpec.IntValue meanTickTH;
    public final ForgeConfigSpec.IntValue meanTickEvent;
    public final ForgeConfigSpec ForgeConfigSpecBuilder;

    public CommonConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("Entity AI Load balancing settings");
        builder.comment("Enables load balancing for entity AI. default = true");
        this.AILoadBalancing = builder.define("AILoadBalancing", true);
        builder.comment("Mean tick time at which AI load balancing takes effect, 1000 / mean tick time = TPS. default: 45");
        this.meanTickAITH = builder.defineInRange("meanTickAITH", 45, 1, 200);
        builder.comment("Whether to debug lagging entities and log offenders, requires load balancing to be enabled. default = true");
        this.logEntityAILag = builder.define("logEntityAILag", true);
        builder.pop();
        builder.push("Tile entities load balancing settings");
        builder.comment("Enables Tileentity load balancing, if the game is lagging. default: true");
        this.TELoadBalancing = builder.define("TELoadBalancing", true);
        builder.comment("Mean tick time at which load balancing takes effect, 1000 / mean tick time = TPS. default: 45");
        this.meanTickTH = builder.defineInRange("meanTickTH", 35, 1, 200);
        builder.comment("Enables debug log output for lagging tileentities, default = false");
        this.TEDebugOutput = builder.define("TEDebugOutput", false);
        builder.push("Tile entity chunk unload");
        builder.comment("Requires TELoadBalancing = true. Enables dealing with lag caused by tile entities during chunk unload. default = false");
        this.TEUnloadLag = builder.define("TEUnloadLag", false);
        builder.pop();
        builder.pop();
        builder.push("Event load balancing settings");
        builder.comment("Enables event load balancing, this is mostly stuff which is happening outside entityAI/Tileentities, if the game is lagging. default: true");
        this.eventLoadBalancing = builder.define("eventLoadBalancing", true);
        builder.comment("Mean tick time at which event load balancing takes effect, 1000 / mean tick time = TPS. default: 45");
        this.meanTickEvent = builder.defineInRange("meanTickEvent", 40, 1, 200);
        builder.comment("Enables debug log output for lagging event subscribers, default = false");
        this.eventDebugOutput = builder.define("eventDebugOutput", false);
        builder.pop();
        builder.push("Entity settings");
        builder.comment("Fix updateleashState lag from llamas, default = true");
        this.fixLeash = builder.define("fixLeash", true);
        builder.comment("Use faster Item entities, default = true");
        this.fastItems = builder.define("fastItems", true);
        builder.comment("Use fast entity collisions, default = true");
        this.fastCollisions = builder.define("fastCollisions", true);
        builder.comment("Enables less laggy entity item pickup, default = true");
        this.noLagItemPickup = builder.define("noLagItemPickup", true);
        builder.comment("Enable fast pathfinding, default = true");
        this.fastPathFind = builder.define("fastPathFinding", true);
        builder.comment("Enable fast inventory advancement triggers, default = true");
        this.fastInventoryAdvancement = builder.define("fastInventoryAdvancement", true);
        builder.pop();
        builder.push("Entity AI Settings");
        builder.comment("Sets the tick, ticks happen 20 times each sec, interval in which non-running AI tasks are rechecked. Vanilla default is 1, this mods suggested default is 4");
        this.goalSelectorTickRate = builder.defineInRange("goalselectorrate", 4, 1, 500);
        builder.comment("Whether to use a slower updated AI tempt goal, tempt is used e.g. for luring sheep with wheat. default = true");
        this.optimizeTempt = builder.define("optimizeTempt", true);
        builder.comment("Whether to use a slower updated AI avoid entity goal, avoid is used e.g. for villagers avoiding zombies so it constantly searches for mobs in the area. default = true");
        this.optimizeAvoid = builder.define("optimizeAvoid", true);
        builder.comment("Whether to use a modified/fixed HurtByTarget goal which is used to call other entities for help. default = true");
        this.optimizeHurtByTarget = builder.define("optimizeHurtByTarget", true);
        builder.comment("Whether to use a slower updated AI Panic entity goal, panic is used for chickens/other animals running away e.g. on fire. default = true");
        this.optimizePanic = builder.define("optimizePanic", true);
        builder.comment("Whether to use a slower updated AI Breed entity goal, breed is used for searching nearby similar animals and doesnt have to be checked that often. default = true");
        this.optimizeBreed = builder.define("optimizeBreed", true);
        builder.comment("Whether to use a slower updated AI Fox find shelter goal, which causes too much load. default = true");
        this.slowFindShelter = builder.define("slowFindShelter", true);
        builder.comment("Whether to use a more performant Random walking goal, which makes mobs path randomly and can lead to lag default = true");
        this.betterRandomWalking = builder.define("betterRandomWalking", true);
        builder.pop();
        builder.push("Other settings");
        builder.comment("Enable fast spawn radius check, default = true");
        this.fastSpawnRadius = builder.define("fastSpawnRadius", true);
        builder.comment("Enable fast chunk block ticks, default = true");
        this.fastChunkBlocks = builder.define("fastChunkBlocks", true);
        builder.pop();
        this.ForgeConfigSpecBuilder = builder.build();
    }
}

