/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.Main;
import edivad.dimstorage.network.packet.UpdateDimBase;
import edivad.dimstorage.tile.TileEntityDimChest;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class UpdateDimChest
extends UpdateDimBase {
    protected boolean collect;

    public UpdateDimChest(PacketBuffer buf) {
        super(buf);
        this.collect = buf.readBoolean();
    }

    public UpdateDimChest(TileEntityDimChest tile) {
        super(tile);
        this.collect = tile.collect;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.collect);
    }

    @Override
    public void customHandle(World world, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(this.pos);
        if (!(tile instanceof TileEntityDimChest)) {
            Main.logger.error("Wrong type of tile entity (expected TileEntityDimChest)!");
            return;
        }
        TileEntityDimChest chest = (TileEntityDimChest)tile;
        chest.setFreq(this.freq);
        chest.locked = this.locked;
        chest.collect = this.collect;
        chest.func_70296_d();
        world.func_184138_a(this.pos, chest.func_195044_w(), chest.func_195044_w(), 3);
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)chest, buf -> buf.func_179255_a(this.pos).writeBoolean(true));
    }
}

