/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileThermopile
extends TileMachineBase {
    private final int MAX_VOLTAGE = 100;
    private final BlutricityStorage storage = new BlutricityStorage(100.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileThermopile() {
        super(BPTileEntityType.THERMOPILE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return super.getCapability(cap);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.storage.resetCurrent();
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(Direction.DOWN)).func_177230_c() == Blocks.field_150353_l && this.storage.getEnergy() < 100.0) {
                this.storage.addEnergy(0.1, false);
            }
            for (Direction facing : Direction.values()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.func_176734_d()).isPresent()) continue;
                IPowerBase exStorage = (IPowerBase)tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.func_176734_d()).orElse(null);
                EnergyHelper.balancePower(exStorage, this.storage);
            }
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.func_74764_b("energy")) {
            INBT nbtstorage = tCompound.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT tCompound) {
        super.writeToPacketNBT(tCompound);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        tCompound.func_218657_a("energy", nbtstorage);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }
}

