/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.tile.tier1.TileWire;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockAlloyWire
extends BlockContainerBase
implements IBPColoredBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final BooleanProperty CONNECTED_FRONT = BooleanProperty.func_177716_a((String)"connected_front");
    public static final BooleanProperty CONNECTED_BACK = BooleanProperty.func_177716_a((String)"connected_back");
    public static final BooleanProperty CONNECTED_LEFT = BooleanProperty.func_177716_a((String)"connected_left");
    public static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.func_177716_a((String)"connected_right");
    private boolean canProvidePower = true;
    final String type;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public BlockAlloyWire(String type) {
        super(Material.field_151576_e, TileWire.class);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("bluepower:" + type + "_wire");
    }

    public BlockAlloyWire(String type, Material material) {
        super(material, TileWire.class);
        this.type = type;
    }

    private BlockState updateSurroundingWire(World worldIn, BlockPos pos, BlockState state) {
        state = this.calculateCurrentChanges(worldIn, pos, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_195593_d(blockpos, (Block)this);
        }
        return state;
    }

    private BlockState calculateCurrentChanges(World worldIn, BlockPos pos1, BlockPos pos2, BlockState state) {
        BlockState iblockstate = state;
        boolean i = (Boolean)state.func_177229_b((IProperty)POWERED);
        this.canProvidePower = false;
        int k = worldIn.func_175687_A(pos1);
        this.canProvidePower = true;
        if (i != k > 0) {
            state = (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(k > 0));
            if (worldIn.func_180495_p(pos1) == iblockstate) {
                worldIn.func_180501_a(pos1, state, 2);
            }
            this.blocksNeedingUpdate.add(pos1);
            for (Direction enumfacing1 : Direction.values()) {
                this.blocksNeedingUpdate.add(pos1.func_177972_a(enumfacing1));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction enumfacing : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(enumfacing), (Block)this);
            }
        }
    }

    public void onBlockAdded(World worldIn, BlockPos pos, BlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingWire(worldIn, pos, state);
            for (Direction enumfacing : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(enumfacing), (Block)this);
            }
            for (Direction enumfacing1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (Direction enumfacing2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, pos)) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        super.func_176206_d(worldIn, pos, state);
        if (!worldIn.func_201672_e().field_72995_K) {
            for (Direction enumfacing : Direction.values()) {
                worldIn.func_201672_e().func_195593_d(pos.func_177972_a(enumfacing), (Block)this);
            }
            this.updateSurroundingWire(worldIn.func_201672_e(), pos, state);
            for (Direction enumfacing1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn.func_201672_e(), pos.func_177972_a(enumfacing1));
            }
            for (Direction enumfacing2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(worldIn.func_201672_e(), blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn.func_201672_e(), blockpos.func_177977_b());
            }
        }
    }

    public void neighborChanged(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.canPlaceBlockAt(worldIn, pos)) {
                this.updateSurroundingWire(worldIn, pos, state);
            } else {
                worldIn.func_175655_b(pos, true);
            }
        }
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_200132_m() || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, POWERED});
    }

    @Override
    public boolean func_149744_f(BlockState state) {
        return this.canProvidePower;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean connected_back = false;
        boolean connected_front = false;
        boolean connected_left = false;
        boolean connected_right = false;
        for (Direction face : FACING.func_177700_c()) {
            BlockState stateof = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(face));
            switch (face) {
                case NORTH: {
                    connected_front = stateof.func_185897_m();
                    break;
                }
                case SOUTH: {
                    connected_back = stateof.func_185897_m();
                    break;
                }
                case WEST: {
                    connected_left = stateof.func_185897_m();
                    break;
                }
                case EAST: {
                    connected_right = stateof.func_185897_m();
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connected_right))).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(connected_left))).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(connected_front))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(connected_back));
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !this.canProvidePower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileWire tile = (TileWire)blockAccess.func_175625_s(pos);
        assert (tile != null);
        if (!(this.canProvidePower && this.isPowerSourceAt(blockAccess, pos, side) && tile.getIsRedstonePowered())) {
            return 0;
        }
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 16 : 0;
    }

    private boolean isPowerSourceAt(IBlockReader worldIn, BlockPos pos, Direction side) {
        BlockPos blockpos = pos.func_177972_a(side);
        BlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_215686_e(worldIn, blockpos);
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_215686_e(worldIn, pos.func_177984_a());
        if (!flag1 && flag && BlockAlloyWire.canConnectUpwardsTo(worldIn, blockpos.func_177984_a())) {
            return true;
        }
        if (BlockAlloyWire.canConnectTo(iblockstate, side, worldIn, pos)) {
            return true;
        }
        if (iblockstate.func_177230_c() == Blocks.field_196633_cV && iblockstate.func_177229_b((IProperty)RedstoneDiodeBlock.field_185512_D) == side) {
            return true;
        }
        return !flag && BlockAlloyWire.canConnectUpwardsTo(worldIn, blockpos.func_177977_b());
    }

    protected static boolean canConnectUpwardsTo(IBlockReader worldIn, BlockPos pos) {
        return BlockAlloyWire.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    protected static boolean canConnectTo(BlockState blockState, @Nullable Direction side, IBlockReader world, BlockPos pos) {
        if (Blocks.field_190976_dk == blockState.func_177230_c()) {
            return side == blockState.func_177229_b((IProperty)ObserverBlock.field_176387_N);
        }
        return blockState.func_177230_c().canConnectRedstone(blockState, world, pos, side);
    }

    @Override
    public int getColor(IBlockReader w, BlockPos pos, int tint) {
        return tint == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1;
    }

    @Override
    public int getColor(int tint) {
        return tint == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1;
    }
}

