/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.TileBPMicroblock;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.util.AABBUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockBPMicroblock
extends ContainerBlock
implements IBPPartBlock,
IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final VoxelShape size;

    public BlockBPMicroblock(VoxelShape size) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.size = size;
        BPBlocks.blockList.add((Block)this);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (tileentity instanceof TileBPMultipart) {
            tileentity = ((TileBPMultipart)tileentity).getTileForState(state);
        }
        if (tileentity instanceof TileBPMicroblock) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("block", ((TileBPMicroblock)tileentity).getBlock().getRegistryName().toString());
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_77982_d(nbt);
            stack.func_200302_a(new TranslationTextComponent(((TileBPMicroblock)tileentity).getBlock().func_149739_a(), new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent(this.func_149739_a(), new Object[0])));
            itemStacks.add(stack);
        }
        return itemStacks;
    }

    public ResourceLocation func_220068_i() {
        return new ResourceLocation("bluepower:blocks/microblock");
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(this.size, (Direction)state.func_177229_b((IProperty)FACING));
    }

    public VoxelShape getSize() {
        return this.size;
    }

    @Override
    public Boolean blockCapability(BlockState state, Capability capability, @Nullable Direction side) {
        return side == ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d();
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state) {
        AxisAlignedBB aabb = this.size.func_197752_a();
        return AABBUtils.rotate(Block.func_208617_a((double)3.0, (double)(aabb.field_72338_b * 16.0), (double)3.0, (double)13.0, (double)aabb.field_72337_e, (double)13.0), (Direction)state.func_177229_b((IProperty)FACING));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        if (player != null && !player.func_213453_ef()) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        Vec3d vec = context.func_195999_j().func_70040_Z();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.func_210769_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState getStateForPlacement(BlockState state, Direction facing, BlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, Hand hand) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileBPMicroblock();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileBPMicroblock && stack.func_77942_o() && stack.func_77978_p().func_74764_b("block")) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("block")));
            ((TileBPMicroblock)tileentity).setBlock(block);
        } else if (tileentity instanceof TileBPMultipart && stack.func_77942_o() && stack.func_77978_p().func_74764_b("block")) {
            TileBPMicroblock tile = (TileBPMicroblock)((TileBPMultipart)tileentity).getTileForState(state);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("block")));
            tile.setBlock(block);
        }
    }
}

