/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.expression.FunctionExpression;
import org.openzen.zenscript.codemodel.member.EnumConstantMember;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.statement.StatementTransformer;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.codemodel.type.storage.UniqueStorageTag;

public abstract class Expression
implements IPartialExpression {
    public static final Expression[] NONE = new Expression[0];
    public final CodePosition position;
    public final StoredType type;
    public final StoredType thrownType;

    public Expression(CodePosition position, StoredType type, StoredType thrownType) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.position = position;
        this.type = type.getNormalized();
        this.thrownType = thrownType;
    }

    public abstract <T> T accept(ExpressionVisitor<T> var1);

    public abstract <C, R> R accept(C var1, ExpressionVisitorWithContext<C, R> var2);

    public abstract Expression transform(ExpressionTransformer var1);

    public final Expression transform(StatementTransformer transformer) {
        return this.transform((Expression expression) -> {
            if (expression instanceof FunctionExpression) {
                FunctionExpression function = (FunctionExpression)expression;
                Statement body = function.body.transform(transformer);
                if (body == function.body) {
                    return function;
                }
                return new FunctionExpression(function.position, function.type, function.closure, function.header, body);
            }
            return expression;
        });
    }

    public abstract Expression normalize(TypeScope var1);

    @Override
    public List<StoredType> getAssignHints() {
        return Collections.singletonList(this.type);
    }

    @Override
    public Expression eval() {
        return this;
    }

    public Expression castExplicit(CodePosition position, TypeScope scope, StoredType asType, boolean optional) {
        return scope.getTypeMembers(this.type).castExplicit(position, this, asType, optional);
    }

    public Expression castImplicit(CodePosition position, TypeScope scope, StoredType asType) {
        return scope.getTypeMembers(this.type).castImplicit(position, this, asType, true);
    }

    public boolean aborts() {
        return false;
    }

    @Override
    public List<StoredType>[] predictCallTypes(CodePosition position, TypeScope scope, List<StoredType> hints, int arguments) {
        TypeMemberGroup group = scope.getTypeMembers(this.type).getGroup(OperatorType.CALL);
        return group.predictCallTypes(position, scope, hints, arguments);
    }

    @Override
    public List<FunctionHeader> getPossibleFunctionHeaders(TypeScope scope, List<StoredType> hints, int arguments) {
        TypeMemberGroup group = scope.getTypeMembers(this.type).getGroup(OperatorType.CALL);
        return group.getMethodMembers().stream().filter(method -> ((FunctionalMemberRef)method.member).getHeader().accepts(arguments) && !((FunctionalMemberRef)method.member).isStatic()).map(method -> ((FunctionalMemberRef)method.member).getHeader()).collect(Collectors.toList());
    }

    @Override
    public Expression call(CodePosition position, TypeScope scope, List<StoredType> hints, CallArguments arguments) throws CompileException {
        TypeMemberGroup group = scope.getTypeMembers(this.type).getGroup(OperatorType.CALL);
        return group.call(position, scope, this, arguments, false);
    }

    @Override
    public IPartialExpression getMember(CodePosition position, TypeScope scope, List<StoredType> hints, GenericName name) throws CompileException {
        TypeMembers members = scope.getTypeMembers(this.type);
        IPartialExpression result = members.getMemberExpression(position, scope, this, name, false);
        if (result == null) {
            throw new CompileException(position, CompileExceptionCode.NO_SUCH_MEMBER, "No such member: " + name.name);
        }
        return result;
    }

    @Override
    public StoredType[] getTypeArguments() {
        return null;
    }

    public void forEachStatement(Consumer<Statement> consumer) {
    }

    public String evaluateStringConstant() {
        throw new UnsupportedOperationException("Cannot evaluate this value to a string constant!");
    }

    public EnumConstantMember evaluateEnumConstant() {
        throw new UnsupportedOperationException("Cannot evaluate this value to an enum constant!");
    }

    public static StoredType binaryThrow(CodePosition position, StoredType left, StoredType right) {
        if (Objects.equals(left, right)) {
            return left;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new InvalidTypeID(position, CompileExceptionCode.DIFFERENT_EXCEPTIONS, "two different exceptions in same operation: " + left.toString() + " and " + right.toString()).stored(UniqueStorageTag.INSTANCE);
    }

    public static StoredType multiThrow(CodePosition position, Expression[] expressions) {
        StoredType result = null;
        for (Expression expression : expressions) {
            result = Expression.binaryThrow(position, result, expression.thrownType);
        }
        return result;
    }

    public static Expression[] transform(Expression[] expressions, ExpressionTransformer transformer) {
        Expression[] tExpressions = new Expression[expressions.length];
        boolean changed = false;
        for (int i = 0; i < tExpressions.length; ++i) {
            Expression tExpression = expressions[i].transform(transformer);
            changed |= tExpression != expressions[i];
            tExpressions[i] = tExpression;
        }
        return changed ? tExpressions : expressions;
    }
}

