/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;

public class GenericMapper {
    public static final GenericMapper EMPTY = new GenericMapper(CodePosition.BUILTIN, null, Collections.emptyMap());
    public final CodePosition position;
    public final GlobalTypeRegistry registry;
    private final Map<TypeParameter, StoredType> mapping;

    public GenericMapper(CodePosition position, GlobalTypeRegistry registry, Map<TypeParameter, StoredType> mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException();
        }
        this.position = position;
        this.registry = registry;
        this.mapping = mapping;
    }

    public Map<TypeParameter, StoredType> getMapping() {
        return this.mapping;
    }

    public StoredType map(StoredType original) {
        return this.mapping.isEmpty() ? original : original.instance(this);
    }

    public StoredType[] map(StoredType[] original) {
        if (this.mapping.isEmpty() || original.length == 0) {
            return original;
        }
        StoredType[] mapped = new StoredType[original.length];
        for (int i = 0; i < original.length; ++i) {
            mapped[i] = original[i].instance(this);
        }
        return mapped;
    }

    public StoredType map(GenericTypeID type) {
        return this.mapping.containsKey(type.parameter) ? this.mapping.get(type.parameter) : type.stored();
    }

    public FunctionHeader map(FunctionHeader original) {
        return this.mapping.isEmpty() ? original : original.withGenericArguments(this);
    }

    public GenericMapper getInner(CodePosition position, GlobalTypeRegistry registry, Map<TypeParameter, StoredType> mapping) {
        HashMap<TypeParameter, StoredType> resultMap = new HashMap<TypeParameter, StoredType>(this.mapping);
        mapping.forEach((typeParameter, storedType) -> {
            if (resultMap.containsKey(typeParameter) && storedType.type instanceof GenericTypeID && ((GenericTypeID)storedType.type).parameter == typeParameter) {
                return;
            }
            resultMap.put((TypeParameter)typeParameter, (StoredType)storedType);
        });
        return new GenericMapper(position, registry, resultMap);
    }

    public GenericMapper getInner(CodePosition position, GlobalTypeRegistry registry, TypeParameter[] parameters) {
        HashMap<TypeParameter, StoredType> resultMap = new HashMap<TypeParameter, StoredType>(this.mapping);
        for (TypeParameter parameter : parameters) {
            resultMap.put(parameter, new StoredType(registry.getGeneric(parameter), null));
        }
        return new GenericMapper(position, registry, resultMap);
    }

    public String toString() {
        if (this.mapping.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        boolean first = true;
        for (Map.Entry<TypeParameter, StoredType> entry : this.mapping.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(entry.getKey().toString()).append(": ").append(entry.getValue());
        }
        result.append('}');
        return result.toString();
    }
}

