/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.transform;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformerSerializer;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class TransformCustom<T extends IIngredient>
implements IIngredientTransformer<T> {
    public static final Map<String, Function<IItemStack, IItemStack>> knownTransformers = new HashMap<String, Function<IItemStack, IItemStack>>();
    private final String uid;
    private Function<IItemStack, IItemStack> function;

    public TransformCustom(String uid, Function<IItemStack, IItemStack> function) {
        this.uid = uid;
        this.function = function;
        if (function != null) {
            knownTransformers.put(uid, function);
        }
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        if (this.function == null) {
            this.function = knownTransformers.get(this.uid);
        }
        if (this.function == null) {
            throw new IllegalStateException("No transformer named '" + this.uid + "' known!");
        }
        return this.function.apply(stack);
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        return String.format("%s.transformCustom('%s')", transformedIngredient.getCommandString(), this.uid);
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return CraftTweakerRegistries.TRANSFORM_CUSTOM_SERIALIZER;
    }

    public static final class TransformCustomSerializer
    implements IIngredientTransformerSerializer<TransformCustom<?>> {
        @Override
        public TransformCustom<?> parse(PacketBuffer buffer) {
            return new TransformCustom(buffer.func_218666_n(), null);
        }

        @Override
        public TransformCustom<?> parse(JsonObject json) {
            String uid = json.getAsJsonPrimitive("uid").getAsString();
            return new TransformCustom(uid, null);
        }

        @Override
        public void write(PacketBuffer buffer, TransformCustom<?> ingredient) {
            buffer.func_180714_a(((TransformCustom)ingredient).uid);
        }

        @Override
        public JsonObject toJson(TransformCustom<?> transformer) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("uid", ((TransformCustom)transformer).uid);
            return jsonObject;
        }

        @Override
        public ResourceLocation getType() {
            return new ResourceLocation("crafttweaker", "transform_custom");
        }
    }
}

