/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.data;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.crafting.recipe.AssemblyScavengeRecipe;
import vazkii.psi.common.crafting.recipe.BulletToDriveRecipe;
import vazkii.psi.common.crafting.recipe.ColorizerChangeRecipe;
import vazkii.psi.common.crafting.recipe.DriveDuplicateRecipe;
import vazkii.psi.common.crafting.recipe.SensorAttachRecipe;
import vazkii.psi.common.crafting.recipe.SensorRemoveRecipe;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.ModTags;
import vazkii.psi.data.MagicalPsiCondition;

public class RecipeGenerator
extends RecipeProvider
implements IConditionBuilder {
    public RecipeGenerator(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        RecipeGenerator.specialRecipe(AssemblyScavengeRecipe.SERIALIZER, consumer);
        RecipeGenerator.specialRecipe(BulletToDriveRecipe.SERIALIZER, consumer);
        RecipeGenerator.specialRecipe(ColorizerChangeRecipe.SERIALIZER, consumer);
        RecipeGenerator.specialRecipe(DriveDuplicateRecipe.SERIALIZER, consumer);
        RecipeGenerator.specialRecipe(SensorAttachRecipe.SERIALIZER, consumer);
        RecipeGenerator.specialRecipe(SensorRemoveRecipe.SERIALIZER, consumer);
        InventoryChangeTrigger.Instance hasIron = this.func_200409_a(Tags.Items.INGOTS_IRON);
        InventoryChangeTrigger.Instance hasPsimetal = this.func_200409_a(ModTags.INGOT_PSIMETAL);
        InventoryChangeTrigger.Instance hasEbonyPsimetal = this.func_200409_a(ModTags.INGOT_EBONY_PSIMETAL);
        InventoryChangeTrigger.Instance hasIvoryPsimetal = this.func_200409_a(ModTags.INGOT_IVORY_PSIMETAL);
        InventoryChangeTrigger.Instance hasPsidust = this.func_200409_a(ModTags.PSIDUST);
        RecipeGenerator.buildMagicalWrapper(Psi.location("assembler"), consumer, (ICriterionInstance)hasIron, "has_iron", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModBlocks.cadAssembler).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_221602_aD).func_200472_a("IPI").func_200472_a("I I").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("programmer"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModBlocks.programmer).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200472_a("IDI").func_200472_a("I I").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("ebony_psimetal"), consumer, (ICriterionInstance)this.func_200403_a((IItemProvider)ModItems.ebonySubstance), "has_ebony_substance", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.ebonyPsimetal).func_200469_a(Character.valueOf('S'), ModTags.EBONY_SUBSTANCE).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a("SSS").func_200472_a("SIS").func_200472_a("SSS"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("ivory_psimetal"), consumer, (ICriterionInstance)this.func_200403_a((IItemProvider)ModItems.ivorySubstance), "has_ivory_substance", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.ivoryPsimetal).func_200469_a(Character.valueOf('S'), ModTags.IVORY_SUBSTANCE).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a("SSS").func_200472_a("SIS").func_200472_a("SSS"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_assembly_iron"), consumer, (ICriterionInstance)hasIron, "has_iron", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadAssemblyIron).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a("III").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_assembly_gold"), consumer, (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_GOLD), "has_gold", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadAssemblyGold).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).func_200472_a("III").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_assembly_psimetal"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadAssemblyPsimetal).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a("III").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_assembly_ebony"), consumer, (ICriterionInstance)hasEbonyPsimetal, "has_ebony_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadAssemblyEbony).func_200469_a(Character.valueOf('I'), ModTags.INGOT_EBONY_PSIMETAL).func_200472_a("III").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_assembly_ivory"), consumer, (ICriterionInstance)hasIvoryPsimetal, "has_ivory_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadAssemblyIvory).func_200469_a(Character.valueOf('I'), ModTags.INGOT_IVORY_PSIMETAL).func_200472_a("III").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_core_basic"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadCoreBasic).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200472_a(" I ").func_200472_a("IDI").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_core_overclocked"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadCoreOverclocked).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).func_200472_a(" I ").func_200472_a("IDI").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_core_conductive"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadCoreConductive).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).func_200472_a(" I ").func_200472_a("IDI").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_core_hyperclocked"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadCoreHyperClocked).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a(" G ").func_200472_a("IDI").func_200472_a(" G "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_core_radiative"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadCoreRadiative).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a(" G ").func_200472_a("IDI").func_200472_a(" G "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_socket_basic"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadSocketBasic).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200472_a("DI ").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_socket_signaling"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadSocketSignaling).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).func_200472_a("DI ").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_socket_large"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadSocketLarge).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).func_200472_a("DI ").func_200472_a("I  "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_socket_transmissive"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadSocketTransmissive).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a("DI ").func_200472_a("IG "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_socket_huge"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadSocketHuge).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a("DI ").func_200472_a("IG "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_battery_basic"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadBatteryBasic).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).func_200472_a("I").func_200472_a("D").func_200472_a("G"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_battery_extended"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadBatteryExtended).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).func_200472_a("I").func_200472_a("D").func_200472_a("G"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_battery_ultradense"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadBatteryUltradense).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.GEM_PSIGEM).func_200469_a(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).func_200472_a("I").func_200472_a("D").func_200472_a("G"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_white"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerWhite).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_WHITE).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_orange"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerOrange).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_ORANGE).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_magenta"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerMagenta).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_MAGENTA).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_light_blue"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerLightBlue).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_LIGHT_BLUE).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_yellow"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerYellow).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_YELLOW).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_lime"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerLime).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_LIME).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_pink"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerPink).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_PINK).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_gray"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerGray).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_GRAY).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_light_gray"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerLightGray).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_LIGHT_GRAY).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_cyan"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerCyan).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_CYAN).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_purple"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerPurple).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_PURPLE).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_blue"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerBlue).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_BLUE).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_brown"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerBrown).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_BROWN).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_green"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerGreen).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_GREEN).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_red"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerRed).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_RED).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_black"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerBlack).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.DYES_BLACK).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_rainbow"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerRainbow).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), Tags.Items.GEMS_PRISMARINE).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_psi"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerPsi).func_200473_b("psi:colorizer").func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('C'), ModTags.PSIDUST).func_200472_a(" D ").func_200472_a("GCG").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_basic"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.spellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200472_a("ID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_projectile"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.projectileSpellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('A'), Tags.Items.ARROWS).func_200472_a("AID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_loopcast"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.loopSpellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('A'), Tags.Items.STRING).func_200472_a("AID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_circle"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.circleSpellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200471_a(Character.valueOf('A'), Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(Tags.Items.SLIMEBALLS), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151126_ay))))).func_200472_a("AID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_grenade"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.grenadeSpellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('A'), Tags.Items.GUNPOWDER).func_200472_a("AID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_charge"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.chargeSpellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('A'), Tags.Items.DUSTS_REDSTONE).func_200472_a("AID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_bullet_mine"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.mineSpellBullet).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('A'), ItemTags.field_200034_d).func_200472_a("AID"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("spell_drive"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.spellDrive).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).func_200472_a("I").func_200472_a("R").func_200472_a("I"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_shovel"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalShovel).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a("GP").func_200472_a(" I").func_200472_a(" I"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_pickaxe"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalPickaxe).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a("PGP").func_200472_a(" I ").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_axe"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalAxe).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a("GP").func_200472_a("PI").func_200472_a(" I"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_sword"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalSword).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a("P").func_200472_a("G").func_200472_a("I"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_exosuit_helmet"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalExosuitHelmet).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a("GPG").func_200472_a("P P"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_exosuit_chestplate"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalExosuitChestplate).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a("P P").func_200472_a("GPG").func_200472_a("PPP"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_exosuit_leggings"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalExosuitLeggings).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a("GPG").func_200472_a("P P").func_200472_a("P P"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_exosuit_boots"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.psimetalExosuitBoots).func_200469_a(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).func_200469_a(Character.valueOf('G'), ModTags.GEM_PSIGEM).func_200472_a("G G").func_200472_a("P P"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("detonator"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.detonator).func_200469_a(Character.valueOf('P'), ModTags.PSIDUST).func_200469_a(Character.valueOf('B'), ItemTags.field_200034_d).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a(" B ").func_200472_a("IPI"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("exosuit_controller"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.exosuitController).func_200469_a(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a("R").func_200472_a("G").func_200472_a("I"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("vector_ruler"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.vectorRuler).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a("D").func_200472_a("I").func_200472_a("I"));
        RecipeGenerator.buildMagicalWrapper(Psi.location("exosuit_sensor_light"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.exosuitSensorLight).func_200469_a(Character.valueOf('M'), Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('R'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" I ").func_200472_a("IMR").func_200472_a(" R "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("exosuit_sensor_water"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.exosuitSensorWater).func_200469_a(Character.valueOf('M'), Tags.Items.GEMS_PRISMARINE).func_200469_a(Character.valueOf('R'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" I ").func_200472_a("IMR").func_200472_a(" R "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("exosuit_sensor_heat"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.exosuitSensorHeat).func_200462_a(Character.valueOf('M'), (IItemProvider)Items.field_151059_bz).func_200469_a(Character.valueOf('R'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" I ").func_200472_a("IMR").func_200472_a(" R "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("exosuit_sensor_stress"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.exosuitSensorStress).func_200462_a(Character.valueOf('M'), (IItemProvider)Items.field_151060_bw).func_200469_a(Character.valueOf('R'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" I ").func_200472_a("IMR").func_200472_a(" R "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("exosuit_sensor_trigger"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.exosuitSensorTrigger).func_200462_a(Character.valueOf('M'), (IItemProvider)Items.field_151016_H).func_200469_a(Character.valueOf('R'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" I ").func_200472_a("IMR").func_200472_a(" R "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("cad_colorizer_empty"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModItems.cadColorizerEmpty).func_200469_a(Character.valueOf('D'), ModTags.PSIDUST).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200472_a(" D ").func_200472_a("G G").func_200472_a(" I "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psidust_block_shapeless"), consumer, (ICriterionInstance)hasPsidust, "has_psidust", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psidustBlock.func_199767_j()).func_200491_b((IItemProvider)ModItems.psidust, 9));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_block_shapeless"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psimetalBlock.func_199767_j()).func_200491_b((IItemProvider)ModItems.psimetal, 9));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psigem_block_shapeless"), consumer, (ICriterionInstance)this.func_200403_a((IItemProvider)ModItems.psigem), "has_psigem", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psigemBlock.func_199767_j()).func_200491_b((IItemProvider)ModItems.psigem, 9));
        RecipeGenerator.buildMagicalWrapper(Psi.location("ebony_block_shapeless"), consumer, (ICriterionInstance)hasEbonyPsimetal, "has_ebony_psimetal", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psimetalEbony.func_199767_j()).func_200491_b((IItemProvider)ModItems.ebonyPsimetal, 9));
        RecipeGenerator.buildMagicalWrapper(Psi.location("ivory_block_shapeless"), consumer, (ICriterionInstance)hasIvoryPsimetal, "has_ivory_psimetal", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psimetalIvory.func_199767_j()).func_200491_b((IItemProvider)ModItems.ivoryPsimetal, 9));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_plate_black"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModBlocks.psimetalPlateBlack.func_199767_j()).func_200469_a(Character.valueOf('C'), ItemTags.field_219775_L).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" C ").func_200472_a("CIC").func_200472_a(" C "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_plate_white"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapedRecipeBuilder.func_200470_a((IItemProvider)ModBlocks.psimetalPlateWhite.func_199767_j()).func_200469_a(Character.valueOf('C'), Tags.Items.GEMS_QUARTZ).func_200469_a(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).func_200472_a(" C ").func_200472_a("CIC").func_200472_a(" C "));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_plate_black_light"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psimetalPlateBlackLight.func_199767_j()).func_203221_a(Tags.Items.DUSTS_GLOWSTONE).func_200487_b((IItemProvider)ModBlocks.psimetalPlateBlack.func_199767_j()));
        RecipeGenerator.buildMagicalWrapper(Psi.location("psimetal_plate_white_light"), consumer, (ICriterionInstance)hasPsimetal, "has_psimetal", ShapelessRecipeBuilder.func_200486_a((IItemProvider)ModBlocks.psimetalPlateWhiteLight.func_199767_j()).func_203221_a(Tags.Items.DUSTS_GLOWSTONE).func_200487_b((IItemProvider)ModBlocks.psimetalPlateWhite.func_199767_j()));
    }

    public String func_200397_b() {
        return "Psi crafting recipes";
    }

    private static void buildMagicalWrapper(ResourceLocation id, Consumer<IFinishedRecipe> consumer, ICriterionInstance recipeUnlockCriterion, String criterionName, ShapelessRecipeBuilder builder) {
        builder.func_200483_a(criterionName, recipeUnlockCriterion);
        RecipeGenerator.buildMagicalWrapper(id, consumer, recipeUnlockCriterion, criterionName, arg_0 -> ((ShapelessRecipeBuilder)builder).func_200482_a(arg_0));
    }

    private static void buildMagicalWrapper(ResourceLocation id, Consumer<IFinishedRecipe> consumer, ICriterionInstance recipeUnlockCriterion, String criterionName, ShapedRecipeBuilder builder) {
        builder.func_200465_a(criterionName, recipeUnlockCriterion);
        RecipeGenerator.buildMagicalWrapper(id, consumer, recipeUnlockCriterion, criterionName, arg_0 -> ((ShapedRecipeBuilder)builder).func_200464_a(arg_0));
    }

    private static void buildMagicalWrapper(ResourceLocation id, Consumer<IFinishedRecipe> consumer, ICriterionInstance criterion, String criterionName, Consumer<Consumer<IFinishedRecipe>> recipe) {
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)MagicalPsiCondition.INSTANCE)).addRecipe(recipe).setAdvancement(Psi.location("recipe/" + id.func_110623_a()), new ConditionalAdvancement.Builder().addCondition((ICondition)new NotCondition((ICondition)MagicalPsiCondition.INSTANCE)).addAdvancement(Advancement.Builder.func_200278_a().func_200272_a(new ResourceLocation("recipes/root")).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200275_a(criterionName, criterion).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200270_a(IRequirementsStrategy.field_223215_b_))).build(consumer, id);
    }

    private static void specialRecipe(SpecialRecipeSerializer<?> serializer, Consumer<IFinishedRecipe> consumer) {
        CustomRecipeBuilder.func_218656_a(serializer).func_200499_a(consumer, Psi.location("dynamic/" + serializer.getRegistryName().func_110623_a()).toString());
    }
}

