/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.helpers.SpellHelpers;

public class PieceTrickBroadcast
extends PieceTrick {
    SpellParam<Number> radius;
    SpellParam<Number> channel;
    SpellParam<Vector3> position;
    SpellParam<Number> signal;
    private static final String SIGNAL_TRACKING_KEY = "psi:BroadcastedSignal";
    private static final String CHANNEL_TRACKING_KEY = "psi:BroadcastedChannel";
    private static final String RECEIVERS_TRACKING_KEY = "psi:BroadcastedToWhom";
    private static final String DUPLICATE_TRACKING_KEY = "psi:AlreadyBroadcasted";

    public PieceTrickBroadcast(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.channel = new ParamNumber("psi.spellparam.channel", SpellParam.RED, true, true);
        this.addParam(this.channel);
        this.radius = new ParamNumber("psi.spellparam.radius", SpellParam.GREEN, false, true);
        this.addParam(this.radius);
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.signal = new ParamNumber("psi.spellparam.number", SpellParam.YELLOW, false, false);
        this.addParam(this.signal);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double radiusVal = SpellHelpers.ensurePositiveAndNonzero(this, this.radius, 32.0);
        SpellHelpers.ensurePositiveOrZero(this, this.channel, 0.0);
        meta.addStat(EnumSpellStat.COST, (int)(radiusVal * 5.0));
        meta.addStat(EnumSpellStat.POTENCY, 5);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = SpellHelpers.getVector3(this, context, this.position, true, false);
        double radiusVal = Math.min(this.getParamValue(context, this.radius).doubleValue(), 32.0);
        int channelVal = ((Number)this.getParamValueOrDefault(context, this.channel, 0)).intValue();
        double signalVal = this.getParamValue(context, this.signal).doubleValue();
        if (context.customData.containsKey(DUPLICATE_TRACKING_KEY)) {
            return null;
        }
        context.customData.put(DUPLICATE_TRACKING_KEY, true);
        ArrayList<PlayerEntity> sec = new ArrayList<PlayerEntity>();
        String channelKey = "psi_broadcast_channel:" + channelVal;
        AxisAlignedBB axis = new AxisAlignedBB(positionVal.x - radiusVal, positionVal.y - radiusVal, positionVal.z - radiusVal, positionVal.x + radiusVal, positionVal.y + radiusVal, positionVal.z + radiusVal);
        List list = context.caster.field_70170_p.func_175647_a(PlayerEntity.class, axis, e -> e != null && e != context.caster && e != context.focalPoint && context.isInRadius((Entity)e));
        if (list.size() > 0) {
            PlayerEntity pl;
            for (Entity ent : list) {
                pl = (PlayerEntity)ent;
                if (PsiAPI.getPlayerCAD(pl) == null) continue;
                sec.add(pl);
            }
            this.writeSecurity(sec, channelVal, signalVal, context.caster, context.caster.field_70170_p);
            for (Entity ent : list) {
                pl = (PlayerEntity)ent;
                if (PsiAPI.getPlayerCAD(pl) == null || pl == null) continue;
                PlayerDataHandler.PlayerData temp = PlayerDataHandler.get(pl);
                temp.getCustomData().func_74780_a(channelKey, signalVal);
                temp.save();
            }
        }
        return null;
    }

    private void writeSecurity(List<PlayerEntity> list, int secChannel, double secSignal, PlayerEntity player, World world) {
        ListNBT list1;
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        if (data.getCustomData().func_74764_b(RECEIVERS_TRACKING_KEY) && data.getCustomData().func_74764_b(CHANNEL_TRACKING_KEY) && data.getCustomData().func_74764_b(SIGNAL_TRACKING_KEY)) {
            list1 = (ListNBT)data.getCustomData().func_74781_a(RECEIVERS_TRACKING_KEY);
            int channel = data.getCustomData().func_74762_e(CHANNEL_TRACKING_KEY);
            double signal = data.getCustomData().func_74769_h(SIGNAL_TRACKING_KEY);
            String key = "psi_broadcast_channel:" + channel;
            for (INBT cmp : list1) {
                PlayerDataHandler.PlayerData pldata;
                CompoundNBT rcmp = (CompoundNBT)cmp;
                PlayerEntity pl = world.func_217371_b(Objects.requireNonNull(rcmp.func_186857_a(RECEIVERS_TRACKING_KEY)));
                if (pl == null || !(pldata = PlayerDataHandler.get(pl)).getCustomData().func_74764_b(key) || pldata.getCustomData().func_74769_h(key) != signal) continue;
                pldata.getCustomData().func_82580_o(key);
                pldata.save();
            }
        }
        list1 = new ListNBT();
        for (PlayerEntity pl : list) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_186854_a(RECEIVERS_TRACKING_KEY, pl.func_110124_au());
            list1.add((Object)nbt);
        }
        data.getCustomData().func_218657_a(RECEIVERS_TRACKING_KEY, (INBT)list1);
        data.getCustomData().func_74768_a(CHANNEL_TRACKING_KEY, secChannel);
        data.getCustomData().func_74780_a(SIGNAL_TRACKING_KEY, secSignal);
        data.save();
    }
}

