/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickCollapseBlockSequence
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;
    SpellParam<Number> maxBlocks;

    public PieceTrickCollapseBlockSequence(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, true);
        this.addParam(this.maxBlocks);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double maxBlocksVal = (Double)this.getParamEvaluation(this.maxBlocks);
        if (maxBlocksVal == null || maxBlocksVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 20.0));
        meta.addStat(EnumSpellStat.COST, (int)(150.0 + (maxBlocksVal - 1.0) * 100.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 targetVal = this.getParamValue(context, this.target);
        int maxBlocksInt = this.getParamValue(context, this.maxBlocks).intValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        ItemStack tool = context.tool;
        if (tool.func_190926_b()) {
            tool = PsiAPI.getPlayerCAD(context.caster);
        }
        World world = context.caster.field_70170_p;
        Vector3 targetNorm = targetVal.copy().normalize();
        for (BlockPos blockPos : MathHelper.getBlocksAlongRay(positionVal.toVec3D(), positionVal.copy().add(targetNorm.copy().multiply(maxBlocksInt)).toVec3D(), maxBlocksInt)) {
            if (!context.isInRadius(Vector3.fromBlockPos(blockPos))) {
                throw new SpellRuntimeException("psi.spellerror.outsideradius");
            }
            BlockPos posDown = blockPos.func_177977_b();
            BlockState state = world.func_180495_p(blockPos);
            BlockState stateDown = world.func_180495_p(posDown);
            Block block = state.func_177230_c();
            if (!world.func_175660_a(context.caster, blockPos)) {
                return null;
            }
            if (!stateDown.isAir((IBlockReader)world, posDown) || state.func_185887_b((IBlockReader)world, blockPos) == -1.0f || !PieceTrickBreakBlock.canHarvestBlock(block, context.caster, world, blockPos, tool) || world.func_175625_s(blockPos) != null) continue;
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, world, blockPos, tool);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            FallingBlockEntity falling = new FallingBlockEntity(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, state);
            world.func_217376_c((Entity)falling);
        }
        return null;
    }
}

