/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.common.spell.operator.vector.PieceOperatorVectorRaycast;

public class PieceOperatorFocusedEntity
extends PieceOperator {
    SpellParam<Entity> target;

    public PieceOperatorFocusedEntity(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity e = this.getParamValue(context, this.target);
        if (e == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        Entity looked = PieceOperatorFocusedEntity.getEntityLookedAt(e);
        if (looked == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return looked;
    }

    public static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        BlockRayTraceResult pos = PieceOperatorVectorRaycast.raycast(e, 32.0);
        Vec3d positionVector = e.func_174791_d();
        if (e instanceof PlayerEntity) {
            positionVector = positionVector.func_72441_c(0.0, (double)e.func_70047_e(), 0.0);
        }
        if (pos != null) {
            distance = pos.func_216347_e().func_72438_d(positionVector);
        }
        Vec3d lookVector = e.func_70040_Z();
        Vec3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.func_130014_f_().func_72839_b(e, e.func_174813_aQ().func_72314_b(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0).func_72314_b(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.func_70067_L()) {
                double distanceToEntity;
                float collisionBorderSize = entity.func_70111_Y();
                AxisAlignedBB hitbox = entity.func_174813_aQ().func_72314_b((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                Optional interceptPosition = hitbox.func_216365_b(positionVector, reachVector);
                if (hitbox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.func_72438_d((Vec3d)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

