/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import net.minecraft.entity.Entity;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public class PieceOperatorClosestToPoint
extends PieceOperator {
    SpellParam<Vector3> position;
    SpellParam<EntityListWrapper> list;

    public PieceOperatorClosestToPoint(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.list = new ParamEntityListWrapper("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.list);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        EntityListWrapper listVal = this.getParamValue(context, this.list);
        Vector3 positionVal = this.getParamValue(context, this.position);
        return PieceOperatorClosestToPoint.closestToPoint(positionVal, listVal);
    }

    public static Entity closestToPoint(Vector3 position, Iterable<Entity> list) throws SpellRuntimeException {
        double closest = Double.MAX_VALUE;
        Entity closestEntity = null;
        for (Entity e : list) {
            double dist = MathHelper.pointDistanceSpace(position.x, position.y, position.z, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
            if (!(dist < closest)) continue;
            closest = dist;
            closestEntity = e;
        }
        if (closestEntity == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return closestEntity;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

