/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile.container;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.inventory.InventorySocketable;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.block.tile.TileCADAssembler;
import vazkii.psi.common.block.tile.container.slot.InventoryAssemblerOutput;
import vazkii.psi.common.block.tile.container.slot.SlotCADOutput;
import vazkii.psi.common.block.tile.container.slot.SlotSocketable;
import vazkii.psi.common.block.tile.container.slot.ValidatorSlot;

public class ContainerCADAssembler
extends Container {
    @ObjectHolder(value="psi:cad_assembler")
    public static ContainerType<ContainerCADAssembler> TYPE;
    private static final EquipmentSlotType[] equipmentSlots;
    public final TileCADAssembler assembler;
    private final int cadComponentStart;
    private final int socketableStart;
    private final int socketableEnd;
    private final int bulletStart;
    private final int bulletEnd;
    private final int playerStart;
    private final int playerEnd;
    private final int hotbarStart;
    private final int hotbarEnd;
    private final int armorStart;

    public static ContainerCADAssembler fromNetwork(int windowId, PlayerInventory playerInventory, PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        return new ContainerCADAssembler(windowId, playerInventory, (TileCADAssembler)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos));
    }

    public ContainerCADAssembler(int windowId, PlayerInventory playerInventory, TileCADAssembler assembler) {
        super(TYPE, windowId);
        final PlayerEntity player = playerInventory.field_70458_d;
        int playerSize = playerInventory.func_70302_i_();
        this.assembler = assembler;
        IItemHandlerModifiable assemblerInv = assembler.getInventory();
        assembler.clearCachedCAD();
        InventoryAssemblerOutput output = new InventoryAssemblerOutput(player, assembler);
        InventorySocketable bullets = new InventorySocketable(assembler.getSocketableStack());
        this.func_75146_a(new SlotCADOutput(output, assembler, 120, 35));
        this.cadComponentStart = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.ASSEMBLY), 120, 91));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.CORE), 100, 91));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.SOCKET), 140, 91));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.BATTERY), 110, 111));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.DYE), 130, 111));
        this.socketableStart = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotSocketable(assemblerInv, bullets, 0, 35, 21));
        this.socketableEnd = this.field_75151_b.size();
        this.bulletStart = this.field_75151_b.size();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.func_75146_a(new ValidatorSlot(bullets, col + row * 3, 17 + col * 18, 57 + row * 18));
            }
        }
        this.bulletEnd = this.field_75151_b.size();
        int xs = 48;
        int ys = 143;
        this.playerStart = this.field_75151_b.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, xs + col * 18, ys + row * 18));
            }
        }
        this.playerEnd = this.field_75151_b.size();
        this.hotbarStart = this.field_75151_b.size();
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, xs + col * 18, ys + 58));
        }
        this.hotbarEnd = this.field_75151_b.size();
        this.armorStart = this.field_75151_b.size();
        for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
            final EquipmentSlotType slot = equipmentSlots[armorSlot];
            this.func_75146_a(new Slot((IInventory)playerInventory, playerSize - 2 - armorSlot, xs - 27, ys + 18 * armorSlot){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return !stack.func_190926_b() && stack.func_77973_b().canEquip(stack, slot, (Entity)player);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_200829_h[slot.func_188454_b()]);
                }
            });
        }
        this.func_75146_a(new Slot((IInventory)playerInventory, playerSize - 1, 219, 143){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return this.assembler.func_174877_v().func_218140_a(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), true) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int from) {
        ItemStack mergeStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(from);
        if (slot != null && slot.func_75216_d()) {
            ArmorItem armor;
            int armorSlot;
            EnumCADComponent componentType;
            int componentSlot;
            ItemStack stackInSlot = slot.func_75211_c();
            mergeStack = stackInSlot.func_77946_l();
            if (from >= this.playerStart ? (stackInSlot.func_77973_b() instanceof ICADComponent ? !this.func_75135_a(stackInSlot, componentSlot = this.cadComponentStart + (componentType = ((ICADComponent)stackInSlot.func_77973_b()).getComponentType(stackInSlot)).ordinal(), componentSlot + 1, false) : (ISocketable.isSocketable(stackInSlot) ? !this.func_75135_a(stackInSlot, this.socketableStart, this.socketableEnd, false) : (ISpellAcceptor.isAcceptor(stackInSlot) ? !this.func_75135_a(stackInSlot, this.bulletStart, this.bulletEnd, false) : (from < this.hotbarStart ? !this.func_75135_a(stackInSlot, this.hotbarStart, this.hotbarEnd, true) : !this.func_75135_a(stackInSlot, this.playerStart, this.playerEnd, false))))) : (stackInSlot.func_77973_b() instanceof ArmorItem ? !this.func_75135_a(stackInSlot, armorSlot = this.armorStart + (armor = (ArmorItem)stackInSlot.func_77973_b()).func_185083_B_().func_188452_c() - 1, armorSlot + 1, true) && !this.func_75135_a(stackInSlot, this.playerStart, this.hotbarEnd, true) : !this.func_75135_a(stackInSlot, this.playerStart, this.hotbarEnd, true))) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (stackInSlot.func_190916_E() == mergeStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stackInSlot);
        }
        return mergeStack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.assembler.clearCachedCAD();
    }

    static {
        equipmentSlots = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    }
}

