/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.psi.common.crafting.recipe.TrickRecipe;

public class TrickRecipeBuilder {
    private Ingredient input;
    private ItemStack output;
    private ItemStack cadAssembly;
    private ResourceLocation trick;

    private TrickRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static TrickRecipeBuilder of(ItemStack output) {
        output.func_190920_e(1);
        return new TrickRecipeBuilder(output);
    }

    public static TrickRecipeBuilder of(IItemProvider output) {
        return new TrickRecipeBuilder(new ItemStack((IItemProvider)output.func_199767_j()));
    }

    public TrickRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public TrickRecipeBuilder input(ItemStack ... input) {
        this.input = Ingredient.func_193369_a((ItemStack[])input);
        return this;
    }

    public TrickRecipeBuilder input(Tag<Item> input) {
        this.input = Ingredient.func_199805_a(input);
        return this;
    }

    public TrickRecipeBuilder input(IItemProvider ... input) {
        this.input = Ingredient.func_199804_a((IItemProvider[])input);
        return this;
    }

    public TrickRecipeBuilder cad(IItemProvider input) {
        this.cadAssembly = new ItemStack((IItemProvider)input.func_199767_j());
        return this;
    }

    public TrickRecipeBuilder cad(ItemStack input) {
        this.cadAssembly = input;
        return this;
    }

    public TrickRecipeBuilder trick(ResourceLocation trick) {
        this.trick = trick;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output.func_77973_b().getRegistryName());
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.output, this.input, this.cadAssembly, this.trick));
    }

    private static JsonObject serializeStack(ItemStack stack) {
        CompoundNBT nbt = stack.func_77955_b(new CompoundNBT());
        byte c = nbt.func_74771_c("Count");
        if (c != 1) {
            nbt.func_74774_a("count", c);
        }
        nbt.func_82580_o("Count");
        TrickRecipeBuilder.renameTag(nbt, "id", "item");
        TrickRecipeBuilder.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    private static void renameTag(CompoundNBT nbt, String oldName, String newName) {
        INBT tag = nbt.func_74781_a(oldName);
        if (tag != null) {
            nbt.func_82580_o(oldName);
            nbt.func_218657_a(newName, tag);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final Ingredient input;
        private final ItemStack output;
        private final ItemStack cadAssembly;
        private final ResourceLocation trick;
        private final ResourceLocation id;

        protected Result(ResourceLocation id, TrickRecipeBuilder builder) {
            this(id, builder.output, builder.input, builder.cadAssembly, builder.trick);
        }

        protected Result(ResourceLocation id, ItemStack output, Ingredient input, ItemStack cadAssembly, ResourceLocation trick) {
            this.input = input;
            this.output = output;
            this.cadAssembly = cadAssembly;
            this.trick = trick;
            this.id = id;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("input", this.input.func_200304_c());
            json.add("output", (JsonElement)TrickRecipeBuilder.serializeStack(this.output));
            json.add("cad", (JsonElement)TrickRecipeBuilder.serializeStack(this.cadAssembly));
            if (this.trick != null) {
                json.addProperty("trick", this.trick.toString());
            }
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)Objects.requireNonNull(ForgeRegistries.RECIPE_SERIALIZERS.getValue(TrickRecipe.TYPE_ID));
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

