/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.gui.forbiddenmicon.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stal111.forbidden_arcanus.gui.GuiManager;
import com.stal111.forbidden_arcanus.gui.element.GuiElement;
import com.stal111.forbidden_arcanus.gui.element.ItemElement;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconEntry;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconScreen;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.element.FlameElement;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.element.button.ChangeFurnaceTypeButton;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.element.button.ChangeRecipeButton;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.element.button.ChangeRecipeTypeButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RecipePreviewElement
extends GuiElement {
    private ForbiddenmiconEntry entry;
    private final int blitOffset;
    private final FontRenderer font;
    private int currentRecipe = 0;
    private RecipeCategory activeRecipeCategory;
    private ChangeFurnaceTypeButton.FurnaceType activeFurnaceType;
    public List<ChangeRecipeTypeButton> changeRecipeTypeButtons = new ArrayList<ChangeRecipeTypeButton>();
    private ChangeRecipeButton nextRecipeButton;
    private ChangeRecipeButton previousRecipeButton;

    public RecipePreviewElement(GuiManager manager, int posX, int posY, int blitOffset, FontRenderer font) {
        super(posX, posY, 111, 68);
        this.setGuiManager(manager);
        this.blitOffset = blitOffset;
        this.font = font;
        for (RecipeCategory category : RecipeCategory.values()) {
            this.changeRecipeTypeButtons.add(new ChangeRecipeTypeButton(category, blitOffset, category.getStartX(), category.getStartY(), buttonObject -> {
                buttonObject.setActivated(true);
                this.changeRecipeTypeButtons.forEach(button -> {
                    if (button.getRecipeCategory() != ((ChangeRecipeTypeButton)buttonObject).getRecipeCategory()) {
                        button.setActivated(false);
                    }
                });
                this.activeRecipeCategory = ((ChangeRecipeTypeButton)buttonObject).getRecipeCategory();
                this.getChildElements().removeIf(guiObject -> guiObject instanceof ItemElement);
                this.loadRecipe(this.activeRecipeCategory.getRecipeSerializers());
            }, category.getHoverText()));
        }
        this.nextRecipeButton = new ChangeRecipeButton(this.getPosX() + 93, 177, blitOffset, 171, 204, buttonObject -> {
            if (this.currentRecipe + 1 < this.entry.getRecipes(Arrays.asList(IRecipeSerializer.field_222157_a, IRecipeSerializer.field_222158_b)).size()) {
                ++this.currentRecipe;
                this.getChildElements().removeIf(guiObject -> guiObject instanceof ItemElement);
                this.loadRecipe(this.activeRecipeCategory.getRecipeSerializers());
                if (this.currentRecipe + 1 >= this.entry.getRecipes(Arrays.asList(IRecipeSerializer.field_222157_a, IRecipeSerializer.field_222158_b)).size()) {
                    this.nextRecipeButton.setPressable(false);
                }
                this.previousRecipeButton.setPressable(true);
            }
        });
        this.previousRecipeButton = new ChangeRecipeButton(this.getPosX() + 81, 177, blitOffset, 158, 204, buttonObject -> {
            if (this.currentRecipe - 1 >= 0) {
                --this.currentRecipe;
                this.getChildElements().removeIf(guiObject -> guiObject instanceof ItemElement);
                this.loadRecipe(this.activeRecipeCategory.getRecipeSerializers());
                if (this.currentRecipe - 1 < 0) {
                    this.previousRecipeButton.setPressable(false);
                }
                this.nextRecipeButton.setPressable(true);
            }
        });
    }

    @Override
    public String getName() {
        return "recipe_preview";
    }

    @Override
    public void render(int x, int y) {
        if (this.activeRecipeCategory != null) {
            this.bindTexture(ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES);
            this.blit(this.blitOffset, 275, 97, 111, 68, 256, 512);
            int i = 0;
            int j = 88;
            for (RecipeCategory category : RecipeCategory.values()) {
                if (this.entry.getRecipes(category.getRecipeSerializers()) == null) continue;
                ++i;
            }
            while (i > 0) {
                this.blit(this.getPosX() + j, 192, this.blitOffset, 379, 169, 17, 7, 256, 512);
                j -= 18;
                --i;
            }
            if (this.activeRecipeCategory == RecipeCategory.CRAFTING) {
                this.blit(this.getPosX() + 6, 131, this.blitOffset, 221, 195, 98, 56, 256, 512);
            } else if (this.activeRecipeCategory == RecipeCategory.SMELTING) {
                this.blit(this.getPosX() + 26, 143, this.blitOffset, 330, 206, 61, 35, 256, 512);
                RenderSystem.scalef((float)0.77f, (float)0.77f, (float)1.0f);
                this.font.func_211126_b(new TranslationTextComponent("forbiddenmicon.recipe.smelting." + this.activeFurnaceType.toString().toLowerCase(), new Object[0]).func_150254_d(), (float)(this.getPosX() + 8) * 1.29f, (float)(this.getPosY() + 5) * 1.29f, 0xFFFFFF);
            }
        }
    }

    public void setEntry(ForbiddenmiconEntry entry) {
        this.entry = entry;
        this.getChildElements().removeIf(guiObject -> guiObject instanceof ChangeRecipeTypeButton || guiObject instanceof ItemElement || guiObject instanceof ChangeRecipeButton);
        this.activeRecipeCategory = null;
        this.activeFurnaceType = null;
        this.currentRecipe = 0;
        int i = 90;
        for (RecipeCategory category : RecipeCategory.values()) {
            if (entry.getRecipes(category.getRecipeSerializers()) == null) continue;
            for (ChangeRecipeTypeButton changeRecipeTypeButton : this.changeRecipeTypeButtons) {
                if (changeRecipeTypeButton.getRecipeCategory() != category) continue;
                changeRecipeTypeButton.setPos(this.getPosX() + i, 192);
                changeRecipeTypeButton.setActivated(false);
                this.addChildElement(changeRecipeTypeButton);
                i -= 18;
            }
        }
        for (GuiElement object : this.getChildElements()) {
            if (!(object instanceof ChangeRecipeTypeButton)) continue;
            this.activeRecipeCategory = ((ChangeRecipeTypeButton)object).getRecipeCategory();
            break;
        }
        if (this.activeRecipeCategory != null) {
            this.changeRecipeTypeButtons.forEach(button -> {
                if (button.getRecipeCategory() == this.activeRecipeCategory) {
                    button.setActivated(true);
                }
            });
            this.loadRecipe(this.activeRecipeCategory.getRecipeSerializers());
            if (entry.getRecipes(this.activeRecipeCategory.getRecipeSerializers()).size() >= 2 && this.activeRecipeCategory == RecipeCategory.CRAFTING) {
                this.previousRecipeButton.setPressable(false);
                this.nextRecipeButton.setPressable(true);
                this.getChildElements().addAll(Arrays.asList(this.nextRecipeButton, this.previousRecipeButton));
            }
        }
    }

    public boolean entryLoaded() {
        return this.entry != null;
    }

    public void clearEntry() {
        this.entry = null;
        this.getChildElements().removeIf(guiObject -> guiObject instanceof ItemElement || guiObject instanceof ChangeRecipeTypeButton);
    }

    public void loadRecipe(Collection<IRecipeSerializer<?>> recipeSerializers) {
        this.getChildElements().removeIf(guiObject -> guiObject instanceof FlameElement || guiObject instanceof ChangeFurnaceTypeButton);
        Collection<IRecipe<?>> recipes = this.entry.getRecipes(recipeSerializers);
        if (recipes != null) {
            IRecipe recipe = (IRecipe)recipes.toArray()[this.currentRecipe];
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().toArray()[0];
            this.addItems(recipes);
            if (this.activeRecipeCategory == RecipeCategory.SMELTING) {
                int i = this.getPosY() + 2;
                boolean flag = false;
                for (ChangeFurnaceTypeButton.FurnaceType furnaceType : ChangeFurnaceTypeButton.FurnaceType.values()) {
                    for (IRecipeSerializer<?> recipeSerializer : recipeSerializers) {
                        if (recipeSerializer != furnaceType.getRecipeSerializer() || this.entry.getRecipes(Collections.singletonList(recipeSerializer)) == null) continue;
                        ChangeFurnaceTypeButton changeFurnaceTypeButton = new ChangeFurnaceTypeButton(this.getEndX() - 18, i, this.blitOffset, furnaceType, buttonObject -> {
                            for (GuiElement guiObject2 : this.getChildElements()) {
                                if (!(guiObject2 instanceof ChangeFurnaceTypeButton) || ((ChangeFurnaceTypeButton)guiObject2).getFurnaceType() == furnaceType) continue;
                                ((ChangeFurnaceTypeButton)guiObject2).setActivated(false);
                            }
                            buttonObject.setActivated(true);
                            this.activeFurnaceType = furnaceType;
                            this.getChildElements().removeIf(guiObject -> guiObject instanceof ItemElement);
                            this.addItems(this.entry.getRecipes(Collections.singletonList(this.activeFurnaceType.getRecipeSerializer())));
                            Optional optional = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215371_a(this.activeFurnaceType.getRecipeType(), (IInventory)new Inventory(new ItemStack[]{ingredient.func_193365_a()[0]}), (World)Minecraft.func_71410_x().field_71441_e);
                            this.getChildElements().forEach(guiObject -> {
                                if (guiObject instanceof FlameElement) {
                                    ((FlameElement)guiObject).setCookingTime(optional.map(AbstractCookingRecipe::func_222137_e).orElse(200));
                                    ((FlameElement)guiObject).setExperience(optional.map(AbstractCookingRecipe::func_222138_b).orElse(Float.valueOf(0.0f)).floatValue());
                                }
                            });
                        });
                        if (!flag) {
                            changeFurnaceTypeButton.setActivated(true);
                            this.activeFurnaceType = furnaceType;
                        }
                        this.addChildElement(changeFurnaceTypeButton);
                        i += 15;
                        flag = true;
                    }
                }
                Optional optional = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215371_a(this.activeFurnaceType.getRecipeType(), (IInventory)new Inventory(new ItemStack[]{ingredient.func_193365_a()[0]}), (World)Minecraft.func_71410_x().field_71441_e);
                this.addChildElement(new FlameElement(this.getPosX() + 31, 162, optional.map(AbstractCookingRecipe::func_222137_e).orElse(200), optional.map(AbstractCookingRecipe::func_222138_b).orElse(Float.valueOf(0.0f)).floatValue(), FlameElement.FireType.FIRE));
            }
        }
    }

    private void addItems(Collection<IRecipe<?>> recipes) {
        for (int j = 0; j < this.getRecipeIngredients(recipes).size(); ++j) {
            if (this.activeRecipeCategory == RecipeCategory.CRAFTING) {
                if (!this.getRecipeIngredients(recipes).get(j).func_190926_b()) {
                    if (j == 0 || j == 3 || j == 6) {
                        this.addChildElement(new ItemElement(this.getRecipeIngredients(recipes).get(j), this.getPosX() + 8, j == 0 ? 132 : (j == 3 ? 151 : 170)));
                    } else if (j == 1 || j == 4 || j == 7) {
                        this.addChildElement(new ItemElement(this.getRecipeIngredients(recipes).get(j), this.getPosX() + 27, j == 1 ? 132 : (j == 4 ? 151 : 170)));
                    } else {
                        this.addChildElement(new ItemElement(this.getRecipeIngredients(recipes).get(j), this.getPosX() + 46, j == 2 ? 132 : (j == 5 ? 151 : 170)));
                    }
                }
                if (this.getRecipeOutput(recipes).func_190926_b()) continue;
                this.addChildElement(new ItemElement(this.getRecipeOutput(recipes), this.getPosX() + 83, 151));
                continue;
            }
            if (this.activeRecipeCategory != RecipeCategory.SMELTING) continue;
            this.addChildElement(new ItemElement(this.getRecipeIngredients(recipes).get(0), this.getPosX() + 28, 144));
            this.addChildElement(new ItemElement(this.getRecipeOutput(recipes), this.getPosX() + 66, 152));
        }
    }

    public List<ItemStack> getRecipeIngredients(Collection<IRecipe<?>> recipes) {
        IRecipe recipe = (IRecipe)recipes.toArray()[this.currentRecipe];
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        recipe.func_192400_c().forEach(ingredient -> {
            if (ingredient == Ingredient.field_193370_a) {
                list.add(ItemStack.field_190927_a);
            } else {
                list.add(ingredient.func_193365_a()[0]);
            }
        });
        return list;
    }

    public ItemStack getRecipeOutput(Collection<IRecipe<?>> recipes) {
        IRecipe recipe = (IRecipe)recipes.toArray()[this.currentRecipe];
        return recipe.func_77571_b();
    }

    public static enum RecipeCategory {
        CRAFTING(327, 168, "crafting", IRecipeSerializer.field_222158_b, IRecipeSerializer.field_222157_a),
        SMELTING(363, 168, "smelting", new IRecipeSerializer[]{IRecipeSerializer.field_222171_o, IRecipeSerializer.field_222172_p, IRecipeSerializer.field_222173_q});

        private final int startX;
        private final int startY;
        private final String hoverText;
        private final Collection<IRecipeSerializer<?>> recipeSerializers;

        private RecipeCategory(int startX, int startY, String hoverText, IRecipeSerializer<?> ... recipeSerializer) {
            this.startX = startX;
            this.startY = startY;
            this.hoverText = hoverText;
            this.recipeSerializers = Arrays.asList(recipeSerializer);
        }

        public int getStartX() {
            return this.startX;
        }

        public int getStartY() {
            return this.startY;
        }

        public String getHoverText() {
            return this.hoverText;
        }

        public Collection<IRecipeSerializer<?>> getRecipeSerializers() {
            return this.recipeSerializers;
        }
    }
}

