/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.tool;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.DynamicWidthWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;

public final class ToolPanel
extends DynamicWidthWidget<IWidget> {
    private List<IWidget> children = ImmutableList.of();

    public ToolPanel() {
        super(DynamicWidthWidget.WidthOccupierType.MIN_WIDTH);
    }

    public <T extends IWidget> void setActivePanel(@Nullable T panel) {
        if (panel == null) {
            this.children = ImmutableList.of();
        } else {
            this.children = ImmutableList.of(panel);
            panel.setParentWidget(this);
            panel.setX(3);
            panel.setHeight(this.getHeight());
            this.getWindow().setFocusedWidget(panel);
        }
        FactoryManagerGUI.getActiveGUI().getTopLevel().reflow();
    }

    @Override
    public List<IWidget> getChildren() {
        return this.children;
    }

    @Override
    public void reflow() {
        IWidget widget = this.getContainedWidget();
        this.setWidth(widget == null ? 0 : widget.getWidth() + 2 + 2);
    }

    public IWidget getContainedWidget() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        RenderingHelper.renderSideLine(this);
        super.render(mouseX, mouseY, particleTicks);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY)) {
            switch (button) {
                case 0: {
                    this.getWindow().setFocusedWidget(this);
                    break;
                }
                case 1: {
                    this.openContextMenu();
                }
            }
            return true;
        }
        return false;
    }

    private void openContextMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Tool.CtxMenu.CloseToolPanel", b -> this.setActivePanel(null)), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.CtxMenu.ToggleFullscreen", b -> FactoryManagerGUI.getActiveGUI().getPrimaryWindow().toggleFullscreen())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }
}

