/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.widget.Checkbox;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.TextList;
import vswe.stevesfactory.logic.procedure.IAnalogTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;

public class RedstoneStrengthMenu<P extends IProcedure & IClientDataStorage>
extends Menu<P> {
    private NumberField<Integer> begin = NumberField.integerFieldRanged(33, 12, 1, 1, 15);
    private NumberField<Integer> end;
    private Checkbox invertCondition;

    public RedstoneStrengthMenu() {
        this.begin.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
        this.end = NumberField.integerFieldRanged(33, 12, 1, 1, 15);
        this.end.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
        this.invertCondition = new Checkbox(0, 0, 8, 8);
        this.invertCondition.translateLabel("menu.sfm.InvertCondition");
        TextList info = new TextList(this.getWidth() - 20, 16, new ArrayList<String>());
        info.setFontHeight(6);
        info.addLineSplit(I18n.func_135052_a((String)"menu.sfm.RedstoneTrigger.Strength.Info", (Object[])new Object[0]));
        info.setLocation(4, HEADING_BOX.getPortionHeight() + 2);
        this.addChildren(this.begin);
        this.addChildren(this.end);
        this.addChildren(this.invertCondition);
        this.addChildren(info);
        this.reflow();
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        Object procedure = this.getLinkedProcedure();
        this.begin.setValue(((IAnalogTarget)procedure).getAnalogBegin());
        this.begin.onValueUpdated = begin -> ((IAnalogTarget)((Object)procedure)).setAnalogBegin((int)begin);
        this.end.setValue(((IAnalogTarget)procedure).getAnalogEnd());
        this.end.onValueUpdated = end -> ((IAnalogTarget)((Object)procedure)).setAnalogEnd((int)end);
        this.invertCondition.setChecked(((IAnalogTarget)procedure).isInverted());
        this.invertCondition.onStateChange = b -> ((IAnalogTarget)((Object)procedure)).setInverted(b);
    }

    @Override
    public void reflow() {
        int y = HEADING_BOX.getPortionHeight() + 20;
        this.begin.alignLeft(4);
        this.begin.setY(y);
        this.end.alignRight(this.getWidth() - 4);
        this.end.setY(y);
        this.invertCondition.setLocation(4, y + 20);
    }

    @Override
    public void renderContents(int mouseX, int mouseY, float particleTicks) {
        super.renderContents(mouseX, mouseY, particleTicks);
        String text = I18n.func_135052_a((String)"menu.sfm.NumberRange", (Object[])new Object[0]);
        RenderingHelper.drawTextCenteredVertically(text, this.begin.getAbsoluteXRight() + 2, this.begin.getAbsoluteY(), this.begin.getAbsoluteYBottom(), -12566464);
    }

    @Override
    public String getHeadingText() {
        return I18n.func_135052_a((String)"menu.sfm.RedstoneTrigger.Strength", (Object[])new Object[0]);
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        return errors;
    }
}

