/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.network;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.api.logic.ProcedureGraph;
import vswe.stevesfactory.blocks.FactoryManagerTileEntity;

public final class PacketSyncProcedureGraph {
    private DimensionType dimension;
    private BlockPos pos;
    private ProcedureGraph graph;

    public static void encode(PacketSyncProcedureGraph msg, PacketBuffer buf) {
        buf.func_192572_a(Objects.requireNonNull(msg.dimension.getRegistryName()));
        buf.func_179255_a(msg.pos);
        buf.func_150786_a(msg.graph.serialize());
    }

    public static PacketSyncProcedureGraph decode(PacketBuffer buf) {
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)buf.func_192575_l());
        BlockPos pos = buf.func_179259_c();
        ProcedureGraph graph = ProcedureGraph.create();
        graph.deserialize(Objects.requireNonNull(buf.func_150793_b()));
        return new PacketSyncProcedureGraph(dimension, pos, graph);
    }

    public static void handle(PacketSyncProcedureGraph msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Preconditions.checkState((sender != null ? 1 : 0) != 0, (Object)"Invalid usage of a client to server packet");
            World world = sender.field_70170_p;
            TileEntity tile = world.func_175625_s(msg.pos);
            if (tile instanceof FactoryManagerTileEntity) {
                ((FactoryManagerTileEntity)tile).setPGraph(msg.graph);
            } else {
                StevesFactoryManager.logger.error("Received packet with invalid controller position {}!", (Object)msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public PacketSyncProcedureGraph(DimensionType dimension, BlockPos pos, ProcedureGraph graph) {
        this.dimension = dimension;
        this.pos = pos;
        this.graph = graph;
    }
}

