/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.ScrollBar;

public class PanelScrollBar
extends ScrollBar {
    public final Panel panel;

    public PanelScrollBar(Panel parent, ScrollBar.Plane plane, Panel p) {
        super(parent, plane, 0);
        this.panel = p;
        this.panel.attachedScrollbar = this;
    }

    public PanelScrollBar(Panel parent, Panel panel) {
        this(parent, ScrollBar.Plane.VERTICAL, panel);
    }

    @Override
    public void setMinValue(double min) {
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void setMaxValue(double max) {
        super.setMaxValue(max - (double)(this.plane.isVertical ? this.panel.height : this.panel.width));
    }

    @Override
    public void setScrollStep(double s) {
        this.panel.setScrollStep(s);
    }

    @Override
    public double getScrollStep() {
        return this.panel.getScrollStep();
    }

    @Override
    public int getScrollBarSize() {
        double max = this.getMaxValue();
        if (max <= 0.0) {
            return 0;
        }
        int size = this.plane.isVertical ? (int)((double)this.panel.height / (max + (double)this.panel.height) * (double)this.height) : (int)((double)this.panel.width / (max + (double)this.panel.width) * (double)this.width);
        return Math.max(size, 10);
    }

    @Override
    public void onMoved() {
        double value;
        double d = value = this.getMaxValue() <= 0.0 ? 0.0 : this.getValue();
        if (this.plane.isVertical) {
            this.panel.setScrollY(value);
        } else {
            this.panel.setScrollX(value);
        }
    }

    @Override
    public boolean canMouseScroll() {
        return super.canMouseScroll() || this.panel.isMouseOver();
    }
}

