/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();
    public static final GuiBase BLANK_GUI = new GuiBase(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };

    public static void setupDrawing() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void playSound(SoundEvent event, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)pitch));
    }

    public static void drawTexturedRect(int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (u0 == u1 || v0 == v1) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            GuiHelper.addRectToBuffer(buffer, x, y, w, h, col);
            tessellator.func_78381_a();
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            GuiHelper.addRectToBufferWithUV(buffer, x, y, w, h, col, u0, v0, u1, v1);
            tessellator.func_78381_a();
        }
    }

    public static void addRectToBuffer(BufferBuilder buffer, int x, int y, int w, int h, Color4I col) {
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_225582_a_((double)x, (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public static void addRectToBufferWithUV(BufferBuilder buffer, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_225582_a_((double)x, (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_225583_a_(u0, v1).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)y, 0.0).func_225586_a_(r, g, b, a).func_225583_a_(u1, v0).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_225583_a_(u0, v0).func_181675_d();
    }

    public static void drawHollowRect(int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(x, y, w, h);
            return;
        }
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(buffer, x, y + h - 1, w, 1, col);
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
    }

    public static void drawRectWithShade(int x, int y, int w, int h, Color4I col, int intensity) {
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 1, 1, col);
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
    }

    public static boolean drawItem(ItemStack stack, int x, int y, double scaleX, double scaleY, boolean renderOverlay) {
        if (stack.func_190926_b()) {
            return false;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.scaled((double)scaleX, (double)scaleY, (double)1.0);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        if (renderOverlay) {
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            if (font == null) {
                font = Minecraft.func_71410_x().field_71466_p;
            }
            Minecraft.func_71410_x().func_175599_af().func_180453_a(font, stack, 0, 0, null);
        }
        RenderSystem.popMatrix();
        return true;
    }

    public static boolean drawItem(ItemStack stack, int x, int y, boolean renderOverlay) {
        return GuiHelper.drawItem(stack, x, y, 1.0, 1.0, renderOverlay);
    }

    public static void pushScissor(MainWindow screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(MainWindow screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static void setFixUnicode(boolean enabled) {
    }

    public static String clickEventToString(@Nullable ClickEvent event) {
        if (event == null) {
            return "";
        }
        switch (event.func_150669_a()) {
            case OPEN_URL: 
            case CHANGE_PAGE: {
                return event.func_150668_b();
            }
            case OPEN_FILE: {
                return "file:" + event.func_150668_b();
            }
            case RUN_COMMAND: {
                return "command:" + event.func_150668_b();
            }
            case SUGGEST_COMMAND: {
                return "suggest_command:" + event.func_150668_b();
            }
        }
        return "";
    }

    public static void addStackTooltip(ItemStack stack, List<ITextComponent> list) {
        GuiHelper.addStackTooltip(stack, list, null);
    }

    public static void addStackTooltip(ItemStack stack, List<ITextComponent> list, @Nullable ITextComponent prefix) {
        List tooltip = stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        list.add(prefix == null ? ((ITextComponent)tooltip.get(0)).func_212638_h().func_211708_a(stack.func_77953_t().field_77937_e) : prefix.func_212638_h().func_150257_a((ITextComponent)tooltip.get(0)));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add(new StringTextComponent("").func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)tooltip.get(i)));
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(MainWindow screen) {
            double scale = screen.func_198100_s();
            int sx = (int)((double)this.x * scale);
            int sy = (int)((double)(screen.func_198087_p() - (this.y + this.h)) * scale);
            int sw = (int)((double)this.w * scale);
            int sh = (int)((double)this.h * scale);
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

