/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;

public interface IPixelBuffer {
    public int getWidth();

    public int getHeight();

    public int[] getPixels();

    public void setPixels(int[] var1);

    public void setRGB(int var1, int var2, int var3);

    public int getRGB(int var1, int var2);

    default public void setRGB(int startX, int startY, int w, int h, int[] rgbArray) {
        if (startX == 0 && startY == 0 && w == this.getWidth() && h == this.getHeight()) {
            this.setPixels(rgbArray);
            return;
        }
        int off = -1;
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                this.setRGB(x, y, rgbArray[++off]);
            }
        }
    }

    default public void setRGB(int startX, int startY, IPixelBuffer buffer) {
        this.setRGB(startX, startY, buffer.getWidth(), buffer.getHeight(), buffer.getPixels());
    }

    public int[] getRGB(int var1, int var2, int var3, int var4, @Nullable int[] var5);

    default public void fill(int col) {
        int[] pixels = this.getPixels();
        Arrays.fill(pixels, col);
        this.setPixels(pixels);
    }

    default public void fill(int startX, int startY, int w, int h, int col) {
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                this.setRGB(x, y, col);
            }
        }
    }

    public IPixelBuffer copy();

    public IPixelBuffer getSubimage(int var1, int var2, int var3, int var4);

    default public ByteBuffer toByteBuffer(boolean alpha) {
        int[] pixels = this.getPixels();
        ByteBuffer bb = BufferUtils.createByteBuffer((int)(pixels.length * 4));
        byte alpha255 = -1;
        for (int c : pixels) {
            bb.put((byte)(c >> 16));
            bb.put((byte)(c >> 8));
            bb.put((byte)c);
            bb.put(alpha ? (byte)(c >> 24) : alpha255);
        }
        bb.flip();
        return bb;
    }
}

