/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.utils;

import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface ChainedBooleanSupplier
extends BooleanSupplier {
    public static final ChainedBooleanSupplier TRUE = () -> true;
    public static final ChainedBooleanSupplier FALSE = () -> false;

    default public ChainedBooleanSupplier not() {
        return () -> !this.getAsBoolean();
    }

    default public ChainedBooleanSupplier or(BooleanSupplier supplier) {
        return () -> this.getAsBoolean() || supplier.getAsBoolean();
    }

    default public ChainedBooleanSupplier and(BooleanSupplier supplier) {
        return () -> this.getAsBoolean() && supplier.getAsBoolean();
    }

    default public ChainedBooleanSupplier xor(BooleanSupplier supplier) {
        return () -> this.getAsBoolean() != supplier.getAsBoolean();
    }
}

