/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.sidebar;

import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.GuiButtonSidebar;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.SidebarButton;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.SidebarButtonGroup;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.SidebarButtonManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.resources.I18n;

public class GuiButtonSidebarGroup
extends AbstractButton {
    public static Rectangle lastDrawnArea = new Rectangle();
    private final ContainerScreen gui;
    public final List<GuiButtonSidebar> buttons;
    private GuiButtonSidebar mouseOver;

    public GuiButtonSidebarGroup(ContainerScreen g) {
        super(0, 0, 0, 0, "");
        this.gui = g;
        this.buttons = new ArrayList<GuiButtonSidebar>();
    }

    public void render(int mx, int my, float partialTicks) {
        this.buttons.clear();
        this.mouseOver = null;
        int ry = 0;
        for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
            int rx = 0;
            boolean addedAny = false;
            for (SidebarButton button : group.getButtons()) {
                if (!button.isActuallyVisible()) continue;
                this.buttons.add(new GuiButtonSidebar(rx, ry, button));
                ++rx;
                addedAny = true;
            }
            if (!addedAny) continue;
            ++ry;
        }
        for (GuiButtonSidebar button : this.buttons) {
            button.x = 1 + button.buttonX * 17;
            button.y = 1 + button.buttonY * 17;
        }
        this.x = Integer.MAX_VALUE;
        this.y = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (GuiButtonSidebar b : this.buttons) {
            if (b.x >= 0 && b.y >= 0) {
                this.x = Math.min(this.x, b.x);
                this.y = Math.min(this.y, b.y);
                maxX = Math.max(maxX, b.x + 16);
                maxY = Math.max(maxY, b.y + 16);
            }
            if (mx < b.x || my < b.y || mx >= b.x + 16 || my >= b.y + 16) continue;
            this.mouseOver = b;
        }
        this.x -= 2;
        this.y -= 2;
        this.width = (maxX += 2) - this.x;
        this.height = (maxY += 2) - this.y;
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 500.0);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
        FontRenderer font = this.gui.getMinecraft().field_71466_p;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (GuiButtonSidebar b : this.buttons) {
            String text;
            b.button.getIcon().draw(b.x, b.y, 16, 16);
            if (b == this.mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(b.x, b.y, 16, 16);
            }
            if (b.button.getCustomTextHandler() == null || (text = b.button.getCustomTextHandler().get()).isEmpty()) continue;
            int nw = font.func_78256_a(text);
            int width = 16;
            Color4I.LIGHT_RED.draw(b.x + width - nw, b.y - 1, nw + 1, 9);
            font.func_211126_b(text, (float)(b.x + width - nw + 1), (float)b.y, -1);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.mouseOver != null) {
            int mx1 = mx + 10;
            int my1 = Math.max(3, my - 9);
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)this.mouseOver.button.getLangKey(), (Object[])new Object[0]));
            if (this.mouseOver.button.getTooltipHandler() != null) {
                this.mouseOver.button.getTooltipHandler().accept(list);
            }
            int tw = 0;
            for (String s : list) {
                tw = Math.max(tw, font.func_78256_a(s));
            }
            matrixStack.func_227861_a_(0.0, 0.0, 500.0);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            Color4I.DARK_GRAY.draw(mx1 - 3, my1 - 2, tw + 6, 2 + list.size() * 10);
            for (int i = 0; i < list.size(); ++i) {
                font.func_211126_b((String)list.get(i), (float)mx1, (float)(my1 + i * 10), -1);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        lastDrawnArea = new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void onPress() {
        if (this.mouseOver != null) {
            this.mouseOver.button.onClicked(Screen.hasShiftDown());
        }
    }
}

