/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigNumber;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class ConfigInt
extends ConfigNumber<Integer> {
    public ConfigInt(int mn, int mx) {
        super(mn, mx);
    }

    @Override
    public void addInfo(List<String> list) {
        super.addInfo(list);
        if ((Integer)this.min != Integer.MIN_VALUE) {
            list.add(TextFormatting.AQUA + "Min: " + TextFormatting.RESET + StringUtils.formatDouble(((Integer)this.min).intValue()));
        }
        if ((Integer)this.max != Integer.MAX_VALUE) {
            list.add(TextFormatting.AQUA + "Max: " + TextFormatting.RESET + StringUtils.formatDouble(((Integer)this.max).intValue()));
        }
    }

    @Override
    public boolean parse(@Nullable Consumer<Integer> callback, String string) {
        try {
            int v = Long.decode(string).intValue();
            if (v >= (Integer)this.min && v <= (Integer)this.max) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

