/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.world;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
public class MockDelegationWorld
implements IWorld {
    private final IWorld delegate;
    private Map<BlockPos, BlockInfo> posToBlock;

    public MockDelegationWorld(IWorld delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.posToBlock = new HashMap<BlockPos, BlockInfo>();
    }

    public Set<Map.Entry<BlockPos, BlockInfo>> entrySet() {
        return Collections.unmodifiableSet(this.posToBlock.entrySet());
    }

    public void addBlock(@Nonnull BlockPos pos, BlockData data) {
        this.addBlock(null, pos, data);
    }

    public void addBlock(@Nullable IBuildContext context, @Nonnull BlockPos pos, BlockData data) {
        if (data != null) {
            data.placeIn(SimpleBuildContext.builderOf(context).build(this), pos);
        }
    }

    public IWorld getDelegate() {
        return this.delegate;
    }

    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_217378_a(@Nullable PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public List<Entity> func_175674_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super Entity> predicate) {
        return new ArrayList<Entity>();
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> aClass, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        return new ArrayList();
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return new ArrayList();
    }

    @Nullable
    public IChunk func_217353_a(int p_217353_1_, int p_217353_2_, ChunkStatus p_217353_3_, boolean p_217353_4_) {
        return this.func_212866_a_(p_217353_1_, p_217353_2_);
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return this.getDelegate().func_205770_a(heightmapType, pos);
    }

    public boolean func_217377_a(BlockPos blockPos, boolean b) {
        return this.removeOverride(blockPos);
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.func_180495_p(p_217375_1_));
    }

    public long func_72905_C() {
        return this.delegate.func_72905_C();
    }

    public float func_130001_d() {
        return this.delegate.func_130001_d();
    }

    public float func_72826_c(float partialTicks) {
        return this.delegate.func_72826_c(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_72853_d() {
        return this.delegate.func_72853_d();
    }

    public ITickList<Block> func_205220_G_() {
        return this.delegate.func_205220_G_();
    }

    public ITickList<Fluid> func_205219_F_() {
        return this.delegate.func_205219_F_();
    }

    public IChunk func_212866_a_(int chunkX, int chunkZ) {
        return this.delegate.func_212866_a_(chunkX, chunkZ);
    }

    public World func_201672_e() {
        return this.delegate.func_201672_e();
    }

    public WorldInfo func_72912_H() {
        return this.delegate.func_72912_H();
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return this.delegate.func_175649_E(pos);
    }

    public Difficulty func_175659_aa() {
        return this.delegate.func_175659_aa();
    }

    public AbstractChunkProvider func_72863_F() {
        return this.delegate.func_72863_F();
    }

    public Random func_201674_k() {
        return this.delegate.func_201674_k();
    }

    public void func_195592_c(BlockPos pos, Block blockIn) {
    }

    public BlockPos func_175694_M() {
        return this.delegate.func_175694_M();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    public Biome func_226691_t_(BlockPos pos) {
        return this.delegate.func_226691_t_(pos);
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return null;
    }

    public WorldLightManager func_225524_e_() {
        return null;
    }

    public int func_226658_a_(LightType type, BlockPos pos) {
        return this.delegate.func_226658_a_(type, pos);
    }

    public int func_226659_b_(BlockPos pos, int amount) {
        return this.delegate.func_226659_b_(pos, amount);
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.delegate.func_201676_a(heightmapType, x, z);
    }

    public int func_175657_ab() {
        return this.delegate.func_175657_ab();
    }

    public BiomeManager func_225523_d_() {
        return null;
    }

    public WorldBorder func_175723_af() {
        return this.delegate.func_175723_af();
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return this.delegate.func_195585_a(entityIn, shape);
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return this.delegate.func_175627_a(pos, direction);
    }

    public boolean func_201670_d() {
        return this.delegate.func_201670_d();
    }

    public int func_181545_F() {
        return this.delegate.func_181545_F();
    }

    public Dimension func_201675_m() {
        return this.delegate.func_201675_m();
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return null;
        }
        BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            return info.getEntity(this);
        }
        return this.delegate.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        BlockState state = this.getOverriddenState(pos);
        return state != null ? state : Blocks.field_150350_a.func_176223_P();
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public int func_201572_C() {
        return this.delegate.func_201572_C();
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            info.setState(newState);
        } else {
            this.posToBlock.put(pos, this.createInfo(pos, newState));
        }
        return true;
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        return !this.func_180495_p(pos).isAir((IBlockReader)this, pos) && this.func_217377_a(pos, true);
    }

    public boolean func_225521_a_(BlockPos p_225521_1_, boolean p_225521_2_, @Nullable Entity p_225521_3_) {
        return false;
    }

    @Nullable
    public BlockInfo getOverriddenBlock(BlockPos pos) {
        return this.posToBlock.get(pos);
    }

    @Nullable
    public BlockState getOverriddenState(BlockPos pos) {
        BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getState() : null;
    }

    @Nullable
    public TileEntity getOverriddenTile(BlockPos pos) {
        BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getEntity(this) : null;
    }

    public void clear() {
        this.posToBlock.clear();
    }

    public boolean removeOverride(BlockPos pos) {
        BlockInfo info = this.posToBlock.remove(pos);
        if (info != null) {
            info.onRemove();
            return true;
        }
        return false;
    }

    protected BlockInfo createInfo(BlockPos pos, BlockState state) {
        return new BlockInfo(pos, state);
    }

    public static class BlockInfo {
        private BlockPos pos;
        private BlockState state;
        @Nullable
        private TileEntity entity;

        public BlockInfo(BlockPos pos, BlockState state) {
            this.pos = Objects.requireNonNull(pos);
            this.state = Objects.requireNonNull(state);
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockInfo setPos(BlockPos pos) {
            this.pos = Objects.requireNonNull(pos);
            return this;
        }

        public BlockState getState() {
            return this.state;
        }

        public BlockInfo setState(BlockState state) {
            Preconditions.checkNotNull((Object)state);
            if (this.state.func_177230_c() != state.func_177230_c() || !state.hasTileEntity()) {
                this.onRemove();
            }
            this.state = state;
            return this;
        }

        @Nullable
        public TileEntity getEntity(IWorld world) {
            if (this.entity == null && this.state.hasTileEntity()) {
                try {
                    this.entity = this.state.createTileEntity((IBlockReader)world);
                    if (this.entity != null) {
                        this.entity.func_174878_a(this.pos);
                        this.entity.func_226984_a_(null, this.pos);
                        this.entity.onLoad();
                    }
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Tile Entity at {} with state {} threw exception whilst creating.", (Object)this.pos, (Object)this.state, (Object)e);
                }
            }
            return this.entity;
        }

        public void onRemove() {
            if (this.entity != null) {
                try {
                    this.entity.func_145843_s();
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Tile Entity at {} with state {} threw exception whilst removing.", (Object)this.pos, (Object)this.state, (Object)e);
                }
                this.entity = null;
            }
        }
    }
}

