/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.template;

import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.template.Template;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.network.PacketDistributor;

public class InMemoryTemplateProvider
implements ITemplateProvider {
    private final Map<UUID, Template> map = new HashMap<UUID, Template>();

    @Override
    public Template getTemplateForKey(ITemplateKey key) {
        return this.map.computeIfAbsent(this.getId(key), id -> new Template());
    }

    @Override
    public UUID getId(ITemplateKey key) {
        return key.getTemplateId(this::requestFreeId);
    }

    @Override
    public boolean requestUpdate(ITemplateKey key) {
        return false;
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key) {
        return false;
    }

    @Override
    public boolean requestUpdate(ITemplateKey key, PacketDistributor.PacketTarget target) {
        return false;
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key, PacketDistributor.PacketTarget target) {
        return false;
    }

    @Override
    public void setTemplate(ITemplateKey key, Template template) {
        this.map.put(key.getTemplateId(this::requestFreeId), template);
    }

    public void clear() {
        this.map.clear();
    }

    private UUID requestFreeId() {
        UUID res = UUID.randomUUID();
        return this.map.containsKey(res) ? this.requestFreeId() : res;
    }

    @Override
    public void registerUpdateListener(ITemplateProvider.IUpdateListener listener) {
    }

    @Override
    public void removeUpdateListener(ITemplateProvider.IUpdateListener listener) {
    }
}

