/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.save.SaveTemplateProvider;
import com.direwolf20.buildinggadgets.common.save.TemplateSave;
import com.direwolf20.buildinggadgets.common.save.UndoWorldSave;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

public enum SaveManager {
    INSTANCE;

    private SaveTemplateProvider templateProvider = new SaveTemplateProvider(this::getTemplateSave);
    private TemplateSave templateSave;
    private List<UndoSaveContainer> undoSaves = new LinkedList<UndoSaveContainer>();

    public Supplier<UndoWorldSave> registerUndoSave(Function<ServerWorld, UndoWorldSave> ctrFun) {
        UndoSaveContainer container = new UndoSaveContainer(Objects.requireNonNull(ctrFun));
        this.undoSaves.add(container);
        return () -> container.getCurrentSave();
    }

    public void onServerStarted(FMLServerStartedEvent event) {
        BuildingGadgets.LOG.debug("Loading World Saves.");
        ServerWorld world = event.getServer().func_71218_a(DimensionType.field_223227_a_);
        for (UndoSaveContainer c : this.undoSaves) {
            c.acquire(world);
        }
        this.templateSave = SaveManager.getTemplateSave(world, "buildinggadgets_template_save");
        BuildingGadgets.LOG.debug("Finished Loading saves");
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
        BuildingGadgets.LOG.debug("Clearing save caches");
        for (UndoSaveContainer c : this.undoSaves) {
            c.release();
        }
        this.templateSave = null;
        BuildingGadgets.LOG.debug("Finished clearing save caches");
    }

    public static UndoWorldSave getUndoSave(ServerWorld world, IntSupplier maxLengthSupplier, String name) {
        return SaveManager.get(world, () -> new UndoWorldSave(name, maxLengthSupplier), name);
    }

    private static TemplateSave getTemplateSave(ServerWorld world, String name) {
        return SaveManager.get(world, () -> new TemplateSave(name), name);
    }

    private static <T extends WorldSavedData> T get(ServerWorld world, Supplier<T> supplier, String name) {
        return (T)world.func_217481_x().func_215752_a(supplier, name);
    }

    public SaveTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public TemplateSave getTemplateSave() {
        return this.templateSave;
    }

    private static final class UndoSaveContainer {
        private final Function<ServerWorld, UndoWorldSave> constructor;
        @Nullable
        private UndoWorldSave currentSave;

        private UndoSaveContainer(Function<ServerWorld, UndoWorldSave> constructor) {
            this.constructor = constructor;
            this.currentSave = null;
        }

        private void acquire(ServerWorld world) {
            this.currentSave = this.constructor.apply(world);
        }

        @Nullable
        private UndoWorldSave getCurrentSave() {
            return this.currentSave;
        }

        private void release() {
            this.currentSave = null;
        }
    }
}

